#include "msgbox.h"  

static void
on_btn_default_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_destroy(GTK_WIDGET(user_data));
}


GtkWidget* msgbox_new (char *win_title, char *title, char *msg, char *pixmap,int btnmsk)
{
  GtkWidget *win_msg;
  GtkWidget *vbox1;
  GtkWidget *box_title;
  GtkWidget *lbl_title;
  GtkWidget *hseparator1;
  GtkWidget *hbox1;
  GtkWidget *pixmap1;
  GtkWidget *lbl_msg;
  GtkWidget *hbuttonbox1;
  GtkWidget *btn_yes;
  GtkWidget *btn_no;
  GtkWidget *btn_cancel;

  win_msg = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_msg), "win_msg", win_msg);
  gtk_container_set_border_width (GTK_CONTAINER (win_msg), 4);
  gtk_window_set_title (GTK_WINDOW (win_msg), win_title?_(win_title):_(""));
  gtk_window_set_default_size (GTK_WINDOW (win_msg), 510, 300);
  gtk_window_set_policy (GTK_WINDOW (win_msg), FALSE, FALSE, TRUE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (win_msg), vbox1);

  box_title = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (box_title);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "box_title", box_title,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (box_title);
  gtk_box_pack_start (GTK_BOX (vbox1), box_title, FALSE, TRUE, 0);

  lbl_title = gtk_label_new (title?_("Title"):_(""));
  gtk_widget_ref (lbl_title);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "lbl_title", lbl_title,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lbl_title);
  gtk_box_pack_start (GTK_BOX (box_title), lbl_title, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (box_title), hseparator1, FALSE, TRUE, 0);

  if(!title) gtk_widget_hide (box_title);


  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 32);

  pixmap1 = create_pixmap (win_msg, pixmap);
  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (hbox1), pixmap1, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (pixmap1), 10, 10);
  

  lbl_msg = gtk_label_new (_(msg));
  gtk_widget_ref (lbl_msg);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "lbl_msg", lbl_msg,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lbl_msg);
  gtk_box_pack_start (GTK_BOX (hbox1), lbl_msg, TRUE, TRUE, 0);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "hbuttonbox1", hbuttonbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_SPREAD);
  
  btn_yes = gtk_button_new_with_label ((ACCEPT_BUTTON & btnmsk)?_("Accept"):_("Yes"));
  gtk_widget_ref (btn_yes);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "btn_yes", btn_yes,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btn_yes);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), btn_yes);
  GTK_WIDGET_SET_FLAGS (btn_yes, GTK_CAN_DEFAULT);

  btn_no = gtk_button_new_with_label (_("No"));
  gtk_widget_ref (btn_no);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "btn_no", btn_no,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_container_add (GTK_CONTAINER (hbuttonbox1), btn_no);
  GTK_WIDGET_SET_FLAGS (btn_no, GTK_CAN_DEFAULT);
  
  if( NO_BUTTON & btnmsk )  
    gtk_widget_show (btn_no);
  else
    gtk_widget_hide (btn_no);

  btn_cancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (btn_cancel);
  gtk_object_set_data_full (GTK_OBJECT (win_msg), "btn_cancel", btn_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btn_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), btn_cancel);
  GTK_WIDGET_SET_FLAGS (btn_cancel, GTK_CAN_DEFAULT);
  
  if( CANCEL_BUTTON & btnmsk )  
    gtk_widget_show (btn_cancel);
  else
    gtk_widget_hide (btn_cancel);  

  gtk_signal_connect (GTK_OBJECT (btn_yes), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_default_clicked),
                      win_msg);
  gtk_signal_connect (GTK_OBJECT (btn_no), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_default_clicked),
                      win_msg);
  gtk_signal_connect (GTK_OBJECT (btn_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_default_clicked),
                      win_msg);

  return win_msg;
}

void 
msgbox_button_signal_connect(GtkWidget *msgbox,int button,GtkSignalFunc btncb)
{
	GtkWidget *btn;
	switch(button)
		{
			case NO_BUTTON:btn=gtk_object_get_data(GTK_OBJECT(msgbox), "btn_no");
				           break;
			
            case CANCEL_BUTTON:btn=gtk_object_get_data(GTK_OBJECT(msgbox), "btn_cancel");	
				               break;
			default:
			   btn=gtk_object_get_data(GTK_OBJECT(msgbox), "btn_yes");						
		}
		
	
		g_print("%p!!!", btn);
		
    gtk_signal_disconnect_by_func(GTK_OBJECT(btn),GTK_SIGNAL_FUNC(on_btn_default_clicked),
                        msgbox);
    gtk_signal_connect (GTK_OBJECT (btn), "clicked",
		                GTK_SIGNAL_FUNC (btncb),
                        msgbox);
                      
}
	



