# Copyright (C) 2004,2005 by SICEm S.L.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gettext
import sys

from gazpacho.path import languages_dir
from gazpacho import debugwindow

def init_l10n():
    gettext.install('gazpacho', languages_dir, unicode=True)

# we need to call this before anything else because in some Gazpacho classes
# there are l10n strings and so they need the _ function in loading time
init_l10n()

import gtk

from gazpacho import application
from gazpacho.widgetregistry import widget_registry


from os import remove, rmdir, access, R_OK
from os.path import isdir, isfile

import optparse

def dump_param_specs(widget_name):
    wc = widget_registry.get_by_name(widget_name)
    wc.dump_param_specs()

def dump_properties(widget_name):
    wc = widget_registry.get_by_name(widget_name)
    wc.dump_properties()

def launch(filenames=[]):
    sys.excepthook = debugwindow.show
    
    gazpacho = application.Application()

    # Show ProjectWindow first, so we can get
    # the windows from the loaded files on top of it
    gazpacho.show_all()

    project_loaded = False
    for filename in filenames:
        if filename:
            if access(filename, R_OK):
                gazpacho.open_project(filename)
                project_loaded = True
            else:
                print _('Could not open file %s Permission denied.' % filename)

    if not project_loaded:
        gazpacho.new_project()

    gtk.main()

def uninstall():
    """This function removes all the files installed by Gazpacho.
    It takes the file list from files.py, which is created at install time.
    This should be used in Linux only. In Windows use the standard uninstall
    software procedure.
    """
    print _("This will remove Gazpacho and all its files from your hard drive")
    response = raw_input(_("Are you sure do you want to continue? [%s|No] ") %\
                         _("yes"))

    if response != _("yes"):
        return

    print _('Uninstalling Gazpacho'),
    from files import files
    for file in files:
        if isfile(file):
            remove(file)
        elif isdir(file):
            rmdir(file)
        else:
            print _('I do not know how to remove %s' % file)

def main(args=[]):
    parser = optparse.OptionParser()
    parser.add_option('', '--dump',
                      action="store", type="string",
                      dest="dump_param_specs",
                      help=_("Dump widget param specs"))
    parser.add_option('', '--debug',
                      action="store_true", 
                      dest="debug",
                      help=_("Turn on pdb debugging support"))
    parser.add_option('', '--props',
                      action="store", type="string",
                      dest="dump_properties",
                      help=_("Dump widget properties"))
    parser.add_option('', '--uninstall',
                      action="store_true",
                      dest="uninstall",
                      help=_("Uninstall Gazpacho from your hard drive"))
    
    options, args = parser.parse_args(args)

    if options.uninstall:
        uninstall()
        return
    
    if options.dump_param_specs:
        dump_param_specs(options.dump_param_specs)
        return
    elif options.dump_properties:
        dump_properties(options.dump_properties)
        return

    filenames = []
    if len(args) >= 2:
        filenames = args[1:]
        
    if options.debug:
        import pdb
        pdb.run('launch(filenames)', globals(), locals())
    else:
        launch(filenames)
