#!/usr/bin/env python
# vim:sw=4:et
"""Generate a diff file between two models.

Run the module gaphordiff(old_file, new_file). The output will be printed to
stdout.
"""
from gaphor.UML import ElementFactory
import gaphor.parser
import gaphor.storage

def out(str):
    print str

def _load_file(filename):
    elements = gaphor.parser.parse(filename)
    factory = ElementFactory()
    gaphor.storage._load(elements, factory)

    return elements, factory

def check_elements_exist(elements1, elements2, text):
    """Find elements that are in elements1, but not in elements2.
    Note that this checks all elements, UML and diagram items.
    """
    for key in elements1.iterkeys():
        if not elements2.has_key(key):
            out('%s %s (%s)' % (text, key, elements1[key].type))
            # TODO: print qualified name, if possible

def check_reference_list(element1, element2, list1, list2, text):
    for v in list1:
        if v not in list2:
            out('%s %s (%s): %s (%s)' % (text, element1.id, element1.type, v, "Type comes here"))

def check_references(element1, element2, text):
    for key, val in element1.references.items():
        if not element2.references.has_key(key):
            out('%s %s (%s): %s' % (text, element1.id, element1.type, key))
        else:
            val2 = element2.references[key]
            check_reference_list(element1, element2, val, val2, '-')
            check_reference_list(element2, element1, val2, val, '+')

def gaphordiff(old_file, new_file):
    old_elements, old_factory = _load_file(old_file)
    new_elements, new_factory = _load_file(new_file)

    # First check if there are elements in one, but not in the other one
    if len(old_factory.keys()) != len(new_factory.keys()):
        check_elements_exist(new_elements, old_elements, '+')
        check_elements_exist(old_elements, new_elements, '-')

    # Find differences in attributes, enumerations, associations
    for key in old_elements.iterkeys():
        if new_elements.has_key(key):
            
            # Check references:
            check_references(old_elements[key], new_elements[key], '-')
            check_references(new_elements[key], old_elements[key], '+')


if __name__ == '__main__':
    import sys
    gaphordiff(sys.args[1], sys.args[2])

