/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: instDialog.h,v 1.18 2004/09/21 15:29:06 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __INSTDIALOG_H_
#define __INSTDIALOG_H_


#include "../../config.h"

#include "instdialog_q.h"

#include <qstring.h>
#include <qstringlist.h>

#include <fstream>

class instConf;
class QProcess;
class QEventLoop;
class SSHSession;

class instDialog : public instDialog_q {

    Q_OBJECT
    
    bool        ready;
    bool        activationCommandDone;
    instConf   *cnf;

    QString     ssh;
    QString     scp;
    
    QString     confScript;
    QStringList confFiles;
    
    QString     fwb_prompt;
    
    QString     newKeyMsg;
    
    int         phase;

    QString getActivationCmd();

    SSHSession  *session;
    
 public:
    instDialog(instConf *_c);
    virtual ~instDialog();
    
    void setReady(bool f) { ready=f; }

    void summary();

    QString getUName();
    QString getPWD();
    QString getEPWD();

    QWidget* page(int n) { return QWizard::page(n); }
    
    void initiateCopy(const QString &file);
    void runSSH(SSHSession *s);
        
 protected:

    virtual void showEvent( QShowEvent *ev);
    virtual void hideEvent( QHideEvent *ev);

 protected slots:
     void processExited();
     void selected(const QString &title);
     void rejected();
     void testRunRequested();
     
     void append(const QString &line);
     void appendRich(const QString &line);
     void updateProgressBar(int n,bool setsize);

    void continueRun();
    
};


#endif
