/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: FWBTree.h,v 1.5 2004/08/24 04:41:21 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <map>

#include <qstring.h>

namespace libfwbuilder {
    class FWObject;
    class FWObjectDatabase;
};

class FWBTree {

    std::map<QString,QString>  systemGroupTypes;
    std::map<QString,QString>  systemGroupNames;
    std::map<QString,QString>  systemGroupPaths;

 public:
    
    FWBTree();

    static bool isSystem(libfwbuilder::FWObject *obj);
    static bool isStandardId(libfwbuilder::FWObject *obj);
    
    static bool validateForInsertion(libfwbuilder::FWObject *target,libfwbuilder::FWObject *obj);
    static void getStandardSlotForObject(const QString &objType,
                                         QString &parentType,
                                         QString &parentName);
    static libfwbuilder::FWObject* getStandardSlotForObject(libfwbuilder::FWObject* lib,
                                                            const QString &objType);
    static libfwbuilder::FWObject* createNewLibrary(libfwbuilder::FWObjectDatabase *db);

    static FWBTree *standardObjectTreeFormat;

};

