#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
#
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
#
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/examples/naming/client.py,v $
# Version:      @(#)$RCSfile: client.py,v $ $Revision: 1.3 $
#
#############################################################################
""" An example of a client using the naming service. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA

# Naming Service modules.
from Fnorb.cos.naming import CosNaming

# Stubs generated by 'fnidl'.
import Thermometer


def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Get a reference to the initial naming service context.
    ctx = CORBA.ORB_init().resolve_initial_references("NameService")

    # The 'pathname' of the context that holds the thermometer references (kind
    # of equivalent to '/dev/thermometers').
    path = [CosNaming.NameComponent('dev', ''),
            CosNaming.NameComponent('thermometers', '')]

    # Lookup the temperatures of the thermometers in rooms 101-105, and then
    # force a lookup on a non-existent room "106"!
    for room in ["101", "102", "103", "104", "105", "106"]:
        # Create a naming service 'name' for the thermometer.
        name = path + [CosNaming.NameComponent(room, '')]

        try:
            # Lookup the thermometer in the naming service.
            thermometer = ctx.resolve(name)

            # Make sure that the object is not a 'nil object reference'
            # (represented in Python by the value 'None').
            if thermometer is None:
                raise 'Nil object reference!'

            # Make sure that the object implements the expected interface!
            if not thermometer._is_a(CORBA.id(Thermometer.ThermometerIF)):
                raise 'This is not a Thermometer!'

            # Get the temperature of the thermometer!
            print 'Temperature in', room, 'is', thermometer._get_temperature()

        except CosNaming.NamingContext.NotFound:
            print 'No thermometer in room', room

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
