#ifndef TASKS_H
#define TASKS_H

#include <gtk/gtk.h>

struct _Task;

typedef void (*TaskCancel)(struct _Task *);
typedef struct _Task {
  gfloat percdone;

  TaskCancel user_cancel;
  gpointer user_data;

  int list_pos;
  GtkWidget *widget;
  GtkWidget *label;
  GtkWidget *description;
  GtkWidget *progressbar;
  unsigned int is_running:1;
  unsigned int is_changed:4;
  char text[472];
} Task;

#define TASK_CHANGED_POS 1
#define TASK_CHANGED_TEXT 2

Task *task_new(const gchar *description);
void task_add(Task *t);
void task_update(Task *t,gboolean new_text,gfloat pos);
void task_remove(Task *t);
void task_remove_when_idle(Task *t);
void remove_all_tasks(void);
void task_newtext(Task *t, gfloat pos, const char *fmt, ...);

GtkWidget *new_task_widget(void);
void tasks_count_set_title(void);


#endif
