<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).

    Backend module: balance cache invalidation
*/

# invalidates balance cache for $acc
function invalidate_balance( $acc )
{
    global $db;
    global $LANG_err_deloldbal, $LANG_err_readacc;
    
    $r = $db->query( "delete from balances where account=$acc" ); 
    if( check_res_delay( $r, $LANG_err_deloldbal ) )
	return;

    # delete all parent balances recursively
    $parent = $db->getOne( "select parent from accounts where account=$acc" );
    if( check_res_delay( $parent, $LANG_err_readacc ) )
	return;
    if( $parent )
	invalidate_balance( $parent );
}

?>
