#include <entity.h>
#include <gnome.h>
#include <rendgnome.h>



/* there are only 17 writiable arguments to the text item */
#define MAX_TEXT_ARGS 17
static void
rendcanvas_text_render (ENode * node)
{
  GtkArg *args;
  EBuf *buf;
  int num_args = 0;
  int alpha = 255;

  EDEBUG(("canvas", "rendering text item"));

  args = (GtkArg*)malloc(MAX_TEXT_ARGS * sizeof(GtkArg));

  buf = enode_attrib (node, "x", NULL);
  if (!ebuf_empty(buf)) {    
    double x = strtod (buf->str, NULL);

    EDEBUG(("canvas", "setting x attrib to %f", x));

    args[num_args].name = "x";
    args[num_args].type = GTK_TYPE_DOUBLE;
    args[num_args].d.double_data = x;
    num_args ++;
  }

  buf = enode_attrib (node, "y", NULL);
  if (!ebuf_empty(buf)) {    
    double y = strtod (buf->str, NULL);

    EDEBUG(("canvas", "setting y attrib to %f", y));

    args[num_args].name = "y";
    args[num_args].type = GTK_TYPE_DOUBLE;
    args[num_args].d.double_data = y;
    num_args ++;
  }
  
  buf = enode_attrib (node, "text", NULL);
  if (!ebuf_empty(buf)) {    
    gchar *text = g_strdup(buf->str);

    EDEBUG(("canvas", "setting text attrib"));

    args[num_args].name = "text";
    args[num_args].type = GTK_TYPE_STRING;
    args[num_args].d.string_data = text;
    num_args ++;
  }

  /* fixme: the font/fontset crap is something entity users should not have 
     to deal with. */
  buf = enode_attrib (node, "font", NULL);
  if (!ebuf_empty(buf)) {    
    gchar *font = g_strdup(buf->str);

    EDEBUG(("canvas", "setting font attrib"));

    args[num_args].name = "font";
    args[num_args].type = GTK_TYPE_STRING;
    args[num_args].d.string_data = font;
    num_args ++;
  }

  buf = enode_attrib (node, "fontset", NULL);
  if (!ebuf_empty(buf)) {
    gchar *fontset = g_strdup(buf->str);

    EDEBUG(("canvas", "setting fontset attrib"));
    EDEBUG(("canvas", "fontsset attrib is %d - '%s'", (int)buf, buf->str));

    args[num_args].name = "fontset";
    args[num_args].type = GTK_TYPE_STRING;
    args[num_args].d.string_data = fontset;
    num_args ++;
  }

  buf = enode_attrib (node, "alpha", NULL);
  if (!ebuf_empty(buf)) {
    char *tail;

    alpha = strtol (buf->str, &tail, 0);

    if (tail == buf->str)
      alpha = 255;
  }


  buf = enode_attrib (node, "color", NULL);
  if (!ebuf_empty(buf)) {
    GdkColor c;
    int r, g, b;
    guint canvas_color;

    if (gdk_color_parse(buf->str, &c)) {
      r = c.red >> 8;
      g = c.green >> 8;
      b = c.blue >> 8;
      canvas_color = GNOME_CANVAS_COLOR_A (r,g,b,alpha);
      
      args[num_args].name = "fill_color_rgba";
      args[num_args].type = GTK_TYPE_UINT;
      args[num_args].d.uint_data = canvas_color;
      num_args++;
    }
  }


  /* fill in the rest of the text attrbs here */
  EDEBUG(("canvas", "text item - %d args.", num_args));

  enode_set_kv (node, "rendcanvas-num-args", num_args);
  enode_set_kv (node, "rendcanvas-args", args);
  enode_set_kv (node, "rendcanvas-type", gnome_canvas_text_get_type());

  enode_attribs_sync (node);
}

void
rendcanvas_text_init (RendererFlags flags)
{
  Element *element;
  ElementAttr *e_attr;

  if (!flags & RENDERER_REGISTER)
    return;

  element = g_new0 (Element, 1);
  element->tag = "canvas-text";
  element->render_func = rendcanvas_text_render;
  element->destroy_func = rendcanvas_item_destroy;
  element_register (element);

  rendcanvas_register_pos_attrs (element);

  /* register text attribs here */
}
