#include "csink.h"

#ifdef ENTITY_EMBED

CBuf *
cbuf_new_with_data (char *str, int len)
{
    return ebuf_new_with_data (str, len);
}

CBuf *
cbuf_new_with_cbuf (CBuf * e)
{
    return ebuf_new_with_ebuf (e);
}


CBuf *
cbuf_new_with_str (char *str)
{
    return ebuf_new_with_str (str);
}

void
cbuf_free (CBuf * e)
{
    ebuf_free (e);
}

CBuf *
cbuf_append_cbuf (CBuf * a, CBuf * b)
{
    ebuf_append_ebuf (a, b);
    return a;
}

/* THIS IS A KLUDGE */
/* REMOVE ME REMOVE ME REMOVE ME */

void
cdebug (char *domain, char *format, ...)
{
    va_list args;
    char *string;

    va_start (args, format);
    string = g_strdup_vprintf (format, args);
    va_end (args);

    g_print ("%s: %s\n", domain, string);
}



#else

CBuf *
cbuf_new_with_data (char *str, int len)
{
    CBuf *cbuf;
    char *stored_copy;

    cbuf = g_new (CBuf, 1);
    stored_copy = g_new (char, len + 1);	/* Room for the '\0' too. */

    stored_copy = memcpy (stored_copy, str, len);

    cbuf->str = stored_copy;
    cbuf->len = len;

    /* Set one past the len to nul so we can printf the ->str. */
    cbuf->str[len] = '\0';

    return cbuf;
}

CBuf *
cbuf_new_with_cbuf (CBuf * e)
{
    return cbuf_new_with_data (e->str, e->len);
}

CBuf *
cbuf_new_with_str (char *str)
{
    return cbuf_new_with_data (str, strlen (str));
}


void
cbuf_free (CBuf * e)
{
    if (e) {
	if (e->str) {
	    free (e->str);
	    e->str = NULL;
	} else {
	    printf ("Cannot free NULL!\n");
	}
	free (e);
    }
}

CBuf *
cbuf_append_cbuf (CBuf * a, CBuf * b)
{
    /* allocate space for the \0 as well. */
    char *newstr = (char *) malloc (a->len + b->len+1);

    memcpy (newstr, a->str, a->len);
    memcpy (newstr + a->len, b->str, b->len);
    free (a->str);

    a->str = newstr;
    a->len += b->len;

    /* Set one past the len to nul so we can printf the ->str. */    
    a->str[a->len] = '\0'; 

    return a;
}

#endif
