/*
		   Endeavour Pointer Cursor Structure
 */

#ifndef EDVCURSOR_H
#define EDVCURSOR_H

#include <gtk/gtk.h>


/*
 *      Cursor codes:
 *
 *	Must start from 0 and no skipping indices.
 */
typedef enum {
	EDV_CURSOR_CODE_BUSY,
	EDV_CURSOR_CODE_PASSIVE_BUSY,
	EDV_CURSOR_CODE_TEXT,
	EDV_CURSOR_CODE_HAND,
	EDV_CURSOR_CODE_TRANSLATE,
	EDV_CURSOR_CODE_RESIZE,
	EDV_CURSOR_CODE_CROSSHAIR,
	EDV_CURSOR_CODE_INVISIBLE
} edv_cursor_code;


/*
 *	Cursor structure:
 */
typedef struct _edv_cursor_struct	edv_cursor_struct;
struct _edv_cursor_struct {

	edv_cursor_code	code;
	GdkCursor	*cursor;

};
#define EDV_CURSOR(p)	((edv_cursor_struct *)(p))


extern edv_cursor_struct *EDVCursorNew(
        edv_cursor_code code, GdkCursor *gdk_cursor
);
extern edv_cursor_struct *EDVCursorNewGDKPreset(
	edv_cursor_code code, GdkCursorType gdk_cursor_type
);
extern void EDVCursorDelete(edv_cursor_struct *cursor);


#endif	/* EDVCURSOR_H */
