#ifndef __BAYES_H__
#define __BAYES_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko, University of Wroclaw

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

   This file contains implementation of Bayesian Mail Filter, which is
   coverd by Paul Graham's article at
     http://www.paulgraham.com/spam.html
   and
     http://www.paulgraham.com/better.html

   This module was written for course of Artifficial Intelligence at
   University of Wroclaw, Institute of Computer Science.

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "mail.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void bayes_init (void);
extern void bayes_free_resources (void);
extern void bayes_dump_tables (void);
extern void bayes_dump_tables_txt (void);
extern void bayes_load_tables (void);

extern void bayes_scan_spam (mail_t *mail);
extern void bayes_scan_legitimate (mail_t *mail);
extern void bayes_unscan_spam (mail_t *mail);
extern void bayes_unscan_legitimate (mail_t *mail);

extern int  bayes_is_spam (mail_t *mail);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER bayes.h
 *
 ****************************************************************************/
#endif
