#!/usr/bin/perl

# Test file for new features in LIST output parsing.
# It may not entirely reflect the current state of DpkgFtp.pm

@files = ("-rw-r--r--   1 1000     100        124694 Dec 30 23:12 xearth_1.0-12.1.deb",
	  "-rw-rw-r--   1 dwitch   users         130 Jan 31 15:34 df-k.normal",
	  "-rw-r--r--   1 1000     100          1219 Oct  5  1996 xf86_svga-oops");

%months = ('Jan', 0, 
	   'Feb', 1,
	   'Mar', 2,
	   'Avr', 3,
	   'May', 4, 
	   'Jun', 5, 
	   'Jul', 6, 
	   'Aug', 7, 
	   'Sep', 8, 
	   'Oct', 9,
	   'Nov', 10,
	   'Dec', 11);

foreach $file (@files) {
    my ($year, $month, $month_name, $day, $hours, $minutes, $yearOrTime);

    # get the date components from the output of "ls -l"
    if ($file =~ /([^ ]+ *){5}[^ ]+ ([A-Z][a-z]{2}) ([ 0-9][0-9]) ([0-9 ][0-9][:0-9][0-9]{2})/) {
	
	# what we can read
	$month_name = $2;
	$day = 0 + $3;
	$yearOrTime = $4;

	# translate the month name into number
	$month = $months{$month_name};

	# recognize time or year, and compute missing one
	if ($yearOrTime =~ /([0-9]{2}):([0-9]{2})/) {
	    $hours = 0 + $1; $minutes = 0 + $2;
	    my @this_date = gmtime(time());
	    my $this_month = 1 + $this_date[4];
	    my $this_year = $this_date[5];
	    if ($month > $this_month) {
		$year = 1900 + $this_year - 1;
	    } else {
		$year = 1900 + $this_year;
	    }
	} elsif ($yearOrTime =~ / [0-9]{4}/) {
	    $hours = 0; $minutes = 0;
	    $year = 0 + $yearOrTime;
	} else {
	    die "Cannot parse year-or-time";
	}

	print "$year/$month/$day";
	if (defined ($hours)) {
	    print " $hours:$minutes";
	}
	print "\n";
    } else {
	die "Match failed";
    }
}
