/* burn.c --
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <mysql.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "idlist.h"
#include "song.h"
#include "disc.h"


void SymlinkSongs(MYSQL *mysql,IDList *slist,char *destpath)
{
  int pos;
  Song song_data;
  Disc disc_data;
  char new_filename[1024];
  char tmp[1024];
  int int_gain;
  double float_gain;

  for(pos=0;pos<slist->num_ids;pos++) {
    if(LookUpSong(mysql,slist->ids[pos],&song_data)) {
      g_snprintf(new_filename,1024,"%s/%d.mp3",destpath,pos);

      printf("copy %s to %s\n",song_data.filename,new_filename);

      g_snprintf(tmp,1024,"cp %s %s",song_data.filename,new_filename);

      system(tmp);

      if(LookUpDisc(mysql,song_data.discid,&disc_data)) {
	if(disc_data.gain_adjustment) {
	  float_gain=(double)disc_data.gain_adjustment/100.0;

	  float_gain=float_gain/(5.0 * log10(2.0));

	  if(fabs(float_gain) - (double)((int)(fabs(float_gain))) < 0.5)
	    int_gain=(int)float_gain;
	  else
	    int_gain=(int)float_gain + (float_gain < 0 ? -1 : 1);	  

	  printf("gain is %d  --  int gain is %d\n",disc_data.gain_adjustment,
		 int_gain);

	  g_snprintf(tmp,1024,"mp3gain /g %d %s",int_gain,new_filename);

	  system(tmp);
	}
      }
    }
  }
}

/* mkisofs  -D -J -R -o <out> */
