/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Esta rutina genera el archivo configure.ac, a partir del cual se genera
 el script configure usando autoconf.
 Devido a los problemas de conpilacion en otras distribuciones distintas
 a debian, el archivo generado es el configure.in
 *******************************************************************************/
void aut_crear_configure_ac(void)
{
// esta funcion ha sido modificada para que use el archivo configure.in en lugar de configure.ac por problemas de compilacion
// en distribuciones no actualizadas
// para volver a la version con configure.ac descomentar las lineas comentadas y borrar la line o lineas que halla debajo con
// una tabulacion excesiba
	gchar *nombre;
	FILE *archivo;
	gchar *contenido,*tmp;
	gchar *version;
	gchar *lenguaje;
	gchar *libs;
	gchar *libs_usuario;
	gchar *opciones;
	gchar *warnings;
	gchar *srcdir;
	
	DEBUG_MSG(->aut_crear_configure_ac);
	contenido=g_strdup_printf("dnl Process this file with autoconf to produce a configure script.\n");
	tmp=contenido;
//	contenido=g_strdup_printf("%s\nAC_INIT\n",tmp);
		contenido=g_strdup_printf("%s\nAC_INIT(configure.in)\n",tmp);
	g_free(tmp);
	tmp=contenido;
//	contenido=g_strdup_printf("%s\nAC_PREREQ(2.50)\n",tmp);
		contenido=g_strdup_printf("%s\nAC_PREREQ(2.13)\n",tmp);
	g_free(tmp);
	tmp=contenido;
//	contenido=g_strdup_printf("%s\nAC_CONFIG_SRCDIR([configure.ac])\n",tmp);
//	g_free(tmp);
//	tmp=contenido;
	nombre=pro_ejecutable();
	version=pro_version();
	contenido=g_strdup_printf("%sAM_INIT_AUTOMAKE(%s, %s)\n",tmp,nombre,version);
	g_free(nombre);
	g_free(version);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAM_CONFIG_HEADER(config.h)\n",tmp);
	g_free(tmp);
	tmp=contenido;

	libs=pro_librerias_lincado();

	contenido=g_strdup_printf("%s\nAC_PROG_INSTALL\n",tmp);
	g_free(tmp);
	tmp=contenido;

	lenguaje=pro_lenguaje();
	switch (lenguaje[0]) {
		case '0':
			contenido=g_strdup_printf("%s\nAC_PROG_CC\n",tmp);
			break;
		case '1':
			contenido=g_strdup_printf("%s\nAC_PROG_CXX\n",tmp);
			break;
	}
	g_free(tmp);
	tmp=contenido;
	switch (lenguaje[0]) {
		case '0':
			contenido=g_strdup_printf("%s\nAC_LANG_C\n",tmp);
			break;
		case '1':
			contenido=g_strdup_printf("%s\nAC_LANG_CPLUSPLUS\n",tmp);
			break;
	}
	g_free(tmp);
	tmp=contenido;

	if (libs[LGETTEXT]=='1') {
		contenido=g_strdup_printf("%s\ndnl Add the languages wich your aplication supports here.\nALL_LINGUAS=\"\"\nAM_GNU_GETTEXT\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}

	contenido=g_strdup_printf("%s\ndnl Set PACKAGE_LOCALE_DIR in configure.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_LOCALE_DIR, \"${ac_default_prefix}/${DATADIRNAME}/locale\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_LOCALE_DIR, \"${prefix}/${DATADIRNAME}/locale\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;

	contenido=g_strdup_printf("%s\ndnl Set PACKAGE_SOURCE_DIR in config.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%spackagesrcdir=`cd $srcdir && pwd`\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_DEFINE_UNQUOTED(PACKAGE_SOURCE_DIR, \"${packagesrcdir}\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	
	contenido=g_strdup_printf("%s\ndnl Subst PACKAGE_PIXMAPS_DIR and set it in config.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_PIXMAPS_DIR, \"${ac_default_prefix}/share/pixmaps/${PACKAGE}\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_PIXMAPS_DIR=\"${ac_default_prefix}/share/pixmaps/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_PIXMAPS_DIR, \"${prefix}/share/pixmaps/${PACKAGE}\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_PIXMAPS_DIR=\"${prefix}/share/pixmaps/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_SUBST(PACKAGE_PIXMAPS_DIR)\n",tmp);
	g_free(tmp);
	tmp=contenido;

	contenido=g_strdup_printf("%s\ndnl Subst PACKAGE_DATA_DIR and set it in config.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_DATA_DIR, \"${ac_default_prefix}/share/${PACKAGE}\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_DATA_DIR=\"${ac_default_prefix}/share/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_DATA_DIR, \"${prefix}/share/${PACKAGE}\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_DATA_DIR=\"${prefix}/share/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_SUBST(PACKAGE_DATA_DIR)\n",tmp);
	g_free(tmp);
	tmp=contenido;

	//with this lines we try to autodetect the sistem type to create specific defines
	contenido=g_strdup_printf("%s\ndnl Try to autodetect system type\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_CHECK_PROG(SYSTEM_TYPE,uname,`uname -s`,\"FALSE\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${SYSTEM_TYPE}\" = \"xFALSE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tUNAME_DEFS=\"\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tcase $SYSTEM_TYPE in\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tLinux)\n\t\tUNAME_DEFS=\"-D_LINUX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tFreeBSD)\n\t\tUNAME_DEFS=\"-D_FREEBSD\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tNetBSD)\n\t\tUNAME_DEFS=\"-D_NETBSD\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tBSD/OS)\n\t\tUNAME_DEFS=\"-D_BSD_OS\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tOpenBSD)\n\t\tUNAME_DEFS=\"-D_OPENBSD\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tSunOS)\n\t\tUNAME_DEFS=\"-D_SUNOS\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tQNX)\n\t\tUNAME_DEFS=\"-D_QNX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tDarwin)\n\t\tUNAME_DEFS=\"-D_DARWIN\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tIRIX*)\n\t\tUNAME_DEFS=\"-D_IRIX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tHP-UX*)\n\t\tUNAME_DEFS=\"-D_HP_UX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t[cC][yY][gG][wW][iI][nN]*)\n\t\tUNAME_DEFS=\"-D_CYGWIN\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t*)\n\t\tUNAME_DEFS=\"\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tesac\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;

	opciones=pro_opciones_cflags();
	warnings=pro_warnings();
	switch (lenguaje[0]) {
		case '0':
			contenido=g_strdup_printf("%s\nCFLAGS=\"$UNAME_DEFS %s %s\"\n",tmp,opciones,warnings);
			break;
		case '1':
			contenido=g_strdup_printf("%s\nCXXFLAGS=\"$UNAME_DEFS %s %s\"\n",tmp,opciones,warnings);
			break;
	}
	g_free(tmp);
	g_free(opciones);
	g_free(warnings);
	tmp=contenido;
	
	contenido=g_strdup_printf("%s\ndnl Looking for configuration scripts.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	if ((libs[LXML]=='1') && (preferencias.inc_xml!=NULL)) {
		contenido=g_strdup_printf("%sAC_CHECK_PROG(XML_INC,xml-config,%s)\nAC_SUBST(XML_INC)\n",tmp,preferencias.inc_xml);
		g_free(tmp);
		tmp=contenido;
	}
	if ((libs[LGTK]=='1') && (preferencias.inc_gtk!=NULL)) {
#ifdef _LINUX
		contenido=g_strdup_printf("%sAC_CHECK_PROG(GTK_INC,gtk-config,%s)\nAC_SUBST(GTK_INC)\n",tmp,preferencias.inc_gtk);
#endif
#ifdef _FREEBSD
		contenido=g_strdup_printf("%sAC_CHECK_PROG(GTK_INC,gtk12-config,%s)\nAC_SUBST(GTK_INC)\n",tmp,preferencias.inc_gtk);
#endif
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGNOME]=='1') {
		if (preferencias.inc_gnome!=NULL) {
			contenido=g_strdup_printf("%sAC_CHECK_PROG(GNOME_INC,gnome-config,%s)\nAC_SUBST(GNOME_INC)\n",tmp,preferencias.inc_gnome);
			g_free(tmp);
			tmp=contenido;
		}
	}
	if (libs[LGLIB]=='1') {
		if (preferencias.inc_glib!=NULL) {
#ifdef _LINUX
			contenido=g_strdup_printf("%sAC_CHECK_PROG(GLIB_INC,glib-config,%s)\nAC_SUBST(GLIB_INC)\n",tmp,preferencias.inc_glib);
#endif
#ifdef _FREEBSD
			contenido=g_strdup_printf("%sAC_CHECK_PROG(GLIB_INC,glib12-config,%s)\nAC_SUBST(GLIB_INC)\n",tmp,preferencias.inc_glib);
#endif
			g_free(tmp);
			tmp=contenido;
		}
	}
	if (libs[LGNOMEUI]=='1') {
		contenido=g_strdup_printf("%sAC_CHECK_PROG(GNOMEUI_INC,gnome-config,%s)\nAC_SUBST(GNOMEUI_INC)\n",tmp,preferencias.inc_gnomeui);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGNORBA]=='1') {
		contenido=g_strdup_printf("%sAC_CHECK_PROG(GNORBA_INC,gnome-config,%s)\nAC_SUBST(GNORBA_INC)\n",tmp,preferencias.inc_gnorba);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LAUDIOFILE]=='1') {
		contenido=g_strdup_printf("%sAC_CHECK_PROG(AUDIOFILE_INC,audiofile-config,%s)\nAC_SUBST(AUDIOFILE_INC)\n",tmp,preferencias.inc_audiofile);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LESD]=='1') {
		contenido=g_strdup_printf("%sAC_CHECK_PROG(ESD_INC,esd-config,%s)\nAC_SUBST(ESD_INC)\n",tmp,preferencias.inc_esd);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGMODULE]=='1') {
#ifdef _LINUX
		contenido=g_strdup_printf("%sAC_CHECK_PROG(GMODULE_INC,glib-config,%s)\nAC_SUBST(GMODULE_INC)\n",tmp,preferencias.inc_gmodule);
#endif
#ifdef _FREEBSD
		contenido=g_strdup_printf("%sAC_CHECK_PROG(GMODULE_INC,glib12-config,%s)\nAC_SUBST(GMODULE_INC)\n",tmp,preferencias.inc_gmodule);
#endif
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LIMLIB]=='1') {
		contenido=g_strdup_printf("%sAC_CHECK_PROG(IMLIB_INC,imlib-config,%s)\nAC_SUBST(IMLIB_INC)\n",tmp,preferencias.inc_imlib);
		g_free(tmp);
		tmp=contenido;
	}

	contenido=g_strdup_printf("%s\ndnl Looking for libraries.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	if (libs[LGLIB]=='1') {
#ifdef _LINUX
		contenido=g_strdup_printf("%sGLIB_LIB2=`glib-config --libs glib`\nGLIB_LIB=\"\"\n",tmp);
#endif
#ifdef _FREEBSD
		contenido=g_strdup_printf("%sGLIB_LIB2=`glib12-config --libs glib`\nGLIB_LIB=\"\"\n",tmp);
#endif
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GLIB_LIB2 ; do\n\tcase $i in \n\t\t-l*) GLIB_LIB=\"$i $GLIB_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GLIB_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LXML]=='1') {
		contenido=g_strdup_printf("%sXML_LIB2=`xml-config --libs`\nXML_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $XML_LIB2 ; do\n\tcase $i in \n\t\t-l*) XML_LIB=\"$i $XML_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $XML_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LX11]=='1') {
		if (preferencias.lib_x11!=NULL) {
			contenido=g_strdup_printf("%sLIBS=\"%s $LIBS\"\n",tmp,preferencias.lib_x11);
			g_free(tmp);
			tmp=contenido;
		}
		contenido=g_strdup_printf("%sAC_CHECK_LIB(ICE,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(SM,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(Xext,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(X11,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(Xi,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LIMLIB]=='1') {
		contenido=g_strdup_printf("%sIMLIB_LIB2=`imlib-config --libs`\nIMLIB_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $IMLIB_LIB2 ; do\n\tcase $i in \n\t\t-l*) IMLIB_LIB=\"$i $IMLIB_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $IMLIB_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGMODULE]=='1') {
#ifdef _LINUX
		contenido=g_strdup_printf("%sGMODULE_LIB2=`glib-config --libs gmodule`\nGMODULE_LIB=\"\"\n",tmp);
#endif
#ifdef _FREEBSD
		contenido=g_strdup_printf("%sGMODULE_LIB2=`glib12-config --libs gmodule`\nGMODULE_LIB=\"\"\n",tmp);
#endif
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GMODULE_LIB2 ; do\n\tcase $i in \n\t\t-l*) GMODULE_LIB=\"$i $GMODULE_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GMODULE_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGTK]=='1') {
#ifdef _LINUX
		contenido=g_strdup_printf("%sGTK_LIB2=`gtk-config --libs gtk`\nGTK_LIB=\"\"\n",tmp);
#endif
#ifdef _FREEBSD
		contenido=g_strdup_printf("%sGTK_LIB2=`gtk12-config --libs gtk`\nGTK_LIB=\"\"\n",tmp);
#endif
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GTK_LIB2 ; do\n\tcase $i in \n\t\t-l*) GTK_LIB=\"$i $GTK_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GTK_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LORBIT]=='1') {
		contenido=g_strdup_printf("%sORBIT_LIB2=`orbit-config --libs client`\nORBIT_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $ORBIT_LIB2 ; do\n\tcase $i in \n\t\t-l*) ORBIT_LIB=\"$i $ORBIT_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $ORBIT_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sORBIT_LIB2=`orbit-config --libs server`\nORBIT_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $ORBIT_LIB2 ; do\n\tcase $i in \n\t\t-l*) ORBIT_LIB=\"$i $ORBIT_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $ORBIT_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LAUDIOFILE]=='1') {
		contenido=g_strdup_printf("%sAUDIOFILE_LIB2=`audiofile-config --libs`\nAUDIOFILE_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $AUDIOFILE_LIB2 ; do\n\tcase $i in \n\t\t-l*) AUDIOFILE_LIB=\"$i $AUDIOFILE_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $AUDIOFILE_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LESD]=='1') {
		contenido=g_strdup_printf("%sESD_LIB2=`esd-config --libs`\nESD_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $ESD_LIB2 ; do\n\tcase $i in \n\t\t-l*) ESD_LIB=\"$i $ESD_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $ESD_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGNOME]=='1') {
		contenido=g_strdup_printf("%sGNOME_LIB2=`gnome-config --libs gnome`\nGNOME_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GNOME_LIB2 ; do\n\tcase $i in \n\t\t-l*) GNOME_LIB=\"$i $GNOME_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GNOME_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGNOMEUI]=='1') {
		contenido=g_strdup_printf("%sGNOMEUI_LIB2=`gnome-config --libs gnomeui`\nGNOMEUI_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GNOMEUI_LIB2 ; do\n\tcase $i in \n\t\t-l*) GNOMEUI_LIB=\"$i $GNOMEUI_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GNOMEUI_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGNORBA]=='1') {
		contenido=g_strdup_printf("%sGNORBA_LIB2=`gnome-config --libs gnorba`\nGNORBA_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GNORBA_LIB2 ; do\n\tcase $i in \n\t\t-l*) GNORBA_LIB=\"$i $GNORBA_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $GNORBA_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	libs_usuario=pro_librerias_usuario();
	if (libs_usuario!=NULL) {
		contenido=g_strdup_printf("%s%s\nUSER_LIB=\"\"\n",tmp,libs_usuario);
		g_free(tmp);
		tmp=contenido;
		g_free(libs_usuario);
		contenido=g_strdup_printf("%sfor i in $USER_LIBS ; do\n\tcase $i in \n\t\t-l*) USER_LIB=\"$i $USER_LIB\" ;;\n\t\t-L*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $USER_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LELECTRIC_FENCE]=='1') {
		if (preferencias.lib_electric_fence!=NULL) {
			contenido=g_strdup_printf("%sLIBS=\"$LIBS %s\"\n",tmp,preferencias.lib_electric_fence);
			g_free(tmp);
			tmp=contenido;
		}
		contenido=g_strdup_printf("%sAC_CHECK_LIB(efence,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	
//	contenido=g_strdup_printf("%s\nAC_CONFIG_FILES([\nMakefile\n",tmp);
		contenido=g_strdup_printf("%s\nAC_OUTPUT([\nMakefile\n",tmp);
	g_free(tmp);
	tmp=contenido;
	srcdir=pro_srcdir();
	contenido=g_strdup_printf("%s%s/Makefile\n",tmp,srcdir);
	g_free(tmp);
	g_free(srcdir);
	tmp=contenido;
	if (libs[LGETTEXT]=='1') {
		contenido=g_strdup_printf("%spo/Makefile.in\nintl/Makefile\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
//	contenido=g_strdup_printf("%s])\nAC_OUTPUT\n",tmp);
		contenido=g_strdup_printf("%s])\n",tmp);
	g_free(tmp);
	tmp=contenido;
	
//	nombre=pro_nombre_completo_archivo("configure.ac",FALSE);
		nombre=pro_nombre_completo_archivo("configure.in",FALSE);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	g_free(libs);
	g_free(lenguaje);
//	nombre=pro_nombre_completo_archivo("configure.in",FALSE);
//	if (gen_existe_fichero(nombre)) {
//		remove(nombre);
//	}
//	g_free(nombre);
	autoconfiguracion=autoconfiguracion | AUTO_CONF;

	DEBUG_MSG(->aut_crear_configure_ac);
}

/*******************************************************************************
 Esta funcion genera el Makefile.am que hay en la carpeta de las fuentes
 *******************************************************************************/
void aut_crear_makefile_src(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *contenido,*tmp,*siguiente;
	gint cont;
	xmlNodePtr nodo;
	gchar *includes;
	gchar *libs;
	gchar *srcdir,*prodir;
	
	DEBUG_MSG(->aut_crear_makefile_src);
	contenido=g_strdup_printf("## Process this file with automake to produce Makefile.in\n");
	tmp=contenido;
	contenido=g_strdup_printf("%s\nINCLUDES=-I/usr/include",tmp);
	g_free(tmp);
	tmp=contenido;
	libs=pro_librerias_lincado();
	if ((libs[LXML]=='1') && (preferencias.inc_xml!=NULL)) {
		contenido=g_strdup_printf("%s @XML_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if ((libs[LGTK]=='1') && (preferencias.inc_gtk!=NULL)) {
		contenido=g_strdup_printf("%s @GTK_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if ((libs[LORBIT]=='1') && (preferencias.inc_orbit!=NULL)) {
		contenido=g_strdup_printf("%s %s",tmp,preferencias.inc_orbit);
		g_free(tmp);
		tmp=contenido;
	}
	if ((libs[LX11]=='1') && (preferencias.inc_x11!=NULL)) {
		contenido=g_strdup_printf("%s %s",tmp,preferencias.inc_x11);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGNOME]=='1') {
		if (preferencias.inc_gnome!=NULL) {
			contenido=g_strdup_printf("%s @GNOME_INC@",tmp);
			g_free(tmp);
			tmp=contenido;
		}
	}
	if (libs[LGLIB]=='1') {
		if (preferencias.inc_glib!=NULL) {
			contenido=g_strdup_printf("%s @GLIB_INC@",tmp);
			g_free(tmp);
			tmp=contenido;
		}
	}
	if (libs[LGNOMEUI]=='1') {
		contenido=g_strdup_printf("%s @GNOMEUI_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGNORBA]=='1') {
		contenido=g_strdup_printf("%s @GNORBA_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LAUDIOFILE]=='1') {
		contenido=g_strdup_printf("%s @AUDIOFILE_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LESD]=='1') {
		contenido=g_strdup_printf("%s @ESD_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LGMODULE]=='1') {
		contenido=g_strdup_printf("%s @GMODULE_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LIMLIB]=='1') {
		contenido=g_strdup_printf("%s @IMLIB_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	g_free(libs);
	includes=pro_includes();
	if (includes!=NULL) {
		contenido=g_strdup_printf("%s %s",tmp,includes);
		g_free(tmp);
		tmp=contenido;
	}
	contenido=g_strdup_printf("%s\n",tmp);
	g_free(tmp);
	tmp=contenido;
	nombre=pro_ejecutable();
	contenido=g_strdup_printf("%s\nbin_PROGRAMS = %s\n",tmp,nombre);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\n%s_SOURCES = \\\n",tmp,nombre);
	g_free(tmp);
	tmp=contenido;
	g_free(nombre);
	nodo=NULL;
	do {
		siguiente=pro_cabeceras(&nodo);
		if (siguiente!=NULL) {
			contenido=g_strdup_printf("%s\t%s \\\n",tmp,siguiente);
			g_free(siguiente);
			g_free(tmp);
			tmp=contenido;
		}
	} while (siguiente!=NULL);
	nodo=NULL;
	do {
		siguiente=pro_fuentes(&nodo);
		if (siguiente!=NULL) {
			contenido=g_strdup_printf("%s\t%s \\\n",tmp,siguiente);
			g_free(siguiente);
			g_free(tmp);
			tmp=contenido;
		}
	} while (siguiente!=NULL);
	for (cont=0;contenido[cont]!=0;cont++);
	for (;contenido[cont]!=' ';cont--);
	contenido[cont]='\n';
	contenido[cont+1]=0;
	prodir=pro_prodir();
	srcdir=pro_srcdir();
	nombre=g_strdup_printf("%s/%s/Makefile.am",prodir,srcdir);
	g_free(prodir);
	g_free(srcdir);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	autoconfiguracion=autoconfiguracion | AUTO_MAKE;

	DEBUG_MSG(<-aut_crear_makefile_src);
}

/*******************************************************************************
 Esta funcion genera el Makefile.am que hay en el directorio raiz del proyecto
 *******************************************************************************/
void aut_crear_makefile(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *contenido,*tmp;
	gchar *srcdir;
	gint cont;
	gchar *libs;
	gchar *pixdir,*datadir;
	
	DEBUG_MSG(->aut_crear_makefile);
	contenido=g_strdup_printf("## Process this file with automake to produce Makefile.in\n");
	tmp=contenido;
	srcdir=pro_srcdir();
	contenido=g_strdup_printf("%s\nSUBDIRS = %s\n",tmp,srcdir);
	g_free(tmp);
	tmp=contenido;
	g_free(srcdir);
	libs=pro_librerias_lincado();
	if (libs[LGETTEXT]=='1') {
		for (cont=0;contenido[cont]!=0;cont++);
		contenido[cont-1]=0;

		contenido=g_strdup_printf("%s intl po\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	g_free(libs);

	pixdir=pro_pixdir();
	datadir=g_strdup("data");
	// here we add instruction to install the pixmaps and data directories
	contenido=g_strdup_printf("%s\ninstall-data-local:\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t@$(NORMAL_INSTALL)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// first the pixmaps directorie
	contenido=g_strdup_printf("%s\tif test -d $(srcdir)/%s; then \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tif test \"x${prefix}\" = \"xNONE\"; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)@PACKAGE_PIXMAPS_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor pixmap in $(srcdir)/%s/*; do \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$pixmap; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$pixmap $(DESTDIR)@PACKAGE_PIXMAPS_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
 	tmp=contenido;
 	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
 	g_free(tmp);
 	tmp=contenido;
 	contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)$(prefix)/share/pixmaps/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor pixmap in $(srcdir)/%s/*; do \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$pixmap; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$pixmap $(DESTDIR)$(prefix)/share/pixmaps/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// second the data directorie
	contenido=g_strdup_printf("%s\tif test -d $(srcdir)/%s; then \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
 	contenido=g_strdup_printf("%s\t\tif test \"x${prefix}\" = \"xNONE\"; then \\\n",tmp);
 	g_free(tmp);
 	tmp=contenido;
 	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)@PACKAGE_DATA_DIR@; \\\n",tmp);
 	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor data in $(srcdir)/%s/*; do \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$data; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$data $(DESTDIR)@PACKAGE_DATA_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)$(prefix)/share/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor data in $(srcdir)/%s/*; do \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$data; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$data $(DESTDIR)$(prefix)/share/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
 	tmp=contenido;
 	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
 	g_free(tmp);
 	tmp=contenido;
 	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfi\n",tmp);
	g_free(tmp);
	tmp=contenido;

	// here we add instructions to include de pixmaps and data directories in the distribution
	contenido=g_strdup_printf("%s\ndist-hook:\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// first the pixmaps directorie
	contenido=g_strdup_printf("%s\tif test -d %s; then \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tmkdir $(distdir)/%s; \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfor pixmap in %s/*; do \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tif test -f $$pixmap; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tcp -p $$pixmap $(distdir)/%s; \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi \\\n\t\tdone \\\n\tfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// second the   data directorie
	contenido=g_strdup_printf("%s\tif test -d %s; then \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tmkdir $(distdir)/%s; \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfor data in %s/*; do \\\n",tmp,datadir);
 	g_free(tmp);
 	tmp=contenido;
 	contenido=g_strdup_printf("%s\t\t\tif test -f $$data; then \\\n",tmp);
 	g_free(tmp);
 	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tcp -p $$data $(distdir)/%s; \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi \\\n\t\tdone \\\n\tfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	g_free(pixdir);
	g_free(datadir);
	
	nombre=pro_nombre_completo_archivo("Makefile.am",FALSE);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	autoconfiguracion=autoconfiguracion | AUTO_MAKE;
	
	DEBUG_MSG(<-aut_crear_makefile);
}

/*******************************************************************************
 Esta funcion genera el archivo profiles.in que se encuentra en la carpeta po
 *******************************************************************************/
void aut_crear_potfiles_in(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *contenido,*tmp,*siguiente;
	xmlNodePtr nodo;
	gchar *libs;
	gchar *srcdir;
	
	libs=pro_librerias_lincado();
	if (libs[LGETTEXT]=='0') {
		g_free(libs);
		return;
	}
	g_free(libs);
	
	DEBUG_MSG(actualizando po/POTFILES.in);
	contenido=g_strdup_printf("# List of source files containing translable strings.\n\n");
	tmp=contenido;
	
	srcdir=pro_srcdir();
	nodo=NULL;
	do {
		siguiente=pro_fuentes(&nodo);
		if (siguiente!=NULL) {
			contenido=g_strdup_printf("%s%s/%s\n",tmp,srcdir,siguiente);
			g_free(siguiente);
			g_free(tmp);
			tmp=contenido;
		}
	} while (siguiente!=NULL);
	g_free(srcdir);

	nombre=pro_prodir();
	tmp=nombre;
	nombre=g_strdup_printf("%s/po/POTFILES.in",tmp);
	g_free(tmp);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
}

/*******************************************************************************
 Esta funcion genera el archivo acconfig.h
 *******************************************************************************/
void aut_crear_acconfig_h(void)
{
	FILE *archivo;
	gchar *contenido,*tmp;
	gchar *libs;
	gchar *nombre;
	gint cont;
	
	DEBUG_MSG(->aut_crear_acconfig_h);

	libs=pro_librerias_lincado();

	contenido=g_strdup_printf("#undef PACKAGE_LOCALE_DIR\n");
	tmp=contenido;
	
	if (libs[LGETTEXT]=='1') {
		contenido=g_strdup_printf("%s#undef ENABLE_NLS\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%s#undef HAVE_CATGETS\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%s#undef HAVE_GETTEXT\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%s#undef HAVE_LC_MESSAGES\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%s#undef HAVE_STPCPY\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%s#undef HAVE_LIBSM\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}

	contenido=g_strdup_printf("%s#undef PACKAGE_SOURCE_DIR\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s#undef PACKAGE_PIXMAPS_DIR\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s#undef PACKAGE_DATA_DIR\n",tmp);
	g_free(tmp);
	tmp=contenido;	

	nombre=pro_nombre_completo_archivo("acconfig..",FALSE);
	for (cont=0;nombre[cont]!=0;cont++);
	nombre[cont-1]='h';
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	g_free(libs);

	autoconfiguracion=autoconfiguracion | AUTO_HEADER;

	DEBUG_MSG(<-aut_crear_acconfig_h);
}
