/* commandfuncs.h
 * header file for functions invoked by user keypresses
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller
 */

#include <denemo/denemo.h> 

void
nudgerightward (struct scoreinfo *si);

void
nudge_downward (struct scoreinfo *si);

void
set_width_to_work_with (struct scoreinfo *si);

void
adjustmeasurewidth (struct scoreinfo *si, gint amount);

void
setcurrents (struct scoreinfo *si);

void
adjuststaffheight (struct scoreinfo *si, gint amount);

void
measureleft (struct scoreinfo *si);

void
measureright (struct scoreinfo *si);

void
staffup (struct scoreinfo *si);

void
staffdown (struct scoreinfo *si);

void
cursorleft (struct scoreinfo *si);

void
cursorright (struct scoreinfo *si);

void
cursorup (struct scoreinfo *si);

void
cursordown (struct scoreinfo *si);

void
shiftcursor (struct scoreinfo *si, gint note_value);

void
insertchord (struct scoreinfo *si, gint duration, gboolean rest);

void
changeduration (struct scoreinfo *si, gint duration);

void
tonechange (struct scoreinfo *si, gboolean remove);

void
changeenshift (struct scoreinfo *si, gint amount);

void
change_stem_directive (struct scoreinfo *si, enum stemdirections amount);

void
changedots (struct scoreinfo *si, gint amount);

void
insertmeasures (struct scoreinfo *si, gint number);

void
appendmeasures (struct scoreinfo *si, gint number);

void
deleteobject (struct scoreinfo *si);

void
deletemeasure (struct scoreinfo *si);

void
deletestaff (struct scoreinfo *si, gint pos);

void
insertclone (struct scoreinfo *si);

void
toend (GtkAction *action, struct scoreinfo *si);

void
tohome (GtkAction *action, struct scoreinfo *si);

void
tonextscore (GtkAction *action, struct scoreinfo *si);

void
inserttuplet (struct scoreinfo *si, gint duration);

void
object_insert (struct scoreinfo *si, mudelaobject *mudela_obj_new);

void
stem_directive_insert (GtkAction *action, gpointer data);

void
toggle_begin_slur (struct scoreinfo *si);

void
toggle_end_slur (struct scoreinfo *si);

void insertgrace(struct scoreinfo *si);

void
toggle_start_crescendo (struct scoreinfo *si);

void
toggle_end_crescendo (struct scoreinfo *si);

void
toggle_start_diminuendo (struct scoreinfo *si);

void
toggle_end_diminuendo (struct scoreinfo *si);

void nextmeasure(struct scoreinfo *si);

void
caution (struct scoreinfo *si);
void displayhelper(struct scoreinfo *si);

gboolean
auto_save_document_timeout(struct scoreinfo *si);
void delete_staff(gpointer callback_data, guint callback_action);

void delete_staff_current(GtkAction *action, gpointer data);
void delete_staff_before(GtkAction *action, gpointer data);
void delete_staff_after(GtkAction *action, gpointer data);
