/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * xpm_draw.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: xpm_draw.c,v 1.8 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <stdio.h>
#include "xpm_draw.h"

/* the following functions perform drawing on a XPM image */

/********************************************/
/* clear the given XPM with the given color */
/********************************************/
void fill_xpm(char *xpm[], unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char)
{
	int y;

	for(y=0;y<xpm_height;y++)
	{
		memset(xpm[array_offset_to_pix+y],color_char,xpm_width);
	}
}

/**************************/
/* draw a horizontal line */
/**************************/
void hline_xpm(char *xpm[], unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, int y, int x1, int x2)
{
	if((y<0)||(y>=xpm_height))
		return;

	/* order values */
	if(x1>x2)
	{
		int a;

		a=x2;
		x2=x1;
		x1=a;
	}

	/* clip coordinates */
	if(x1<0)
		x1=0;
	if(x2>=xpm_width)
		x2=xpm_width-1;

	if(x2>=x1)
		memset(&xpm[array_offset_to_pix+y][x1],color_char,(x2-x1)+1);
}

/************************/
/* draw a vertical line */
/************************/
void vline_xpm(char *xpm[], unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, int x, int y1, int y2)
{
	if((x<0)||(x>=xpm_width))
		return;

	/* order values */
	if(y1>y2)
	{
		int a;

		a=y2;
		y2=y1;
		y1=a;
	}

	/* clip coordinates */
	if(y1<0)
		y1=0;
	if(y2>=xpm_height)
		y2=xpm_height-1;

	while(y1<y2)
	{
		xpm[array_offset_to_pix+y1][x]=color_char;
		y1++;
	}
}

/**************/
/* draw a box */
/**************/
void box_xpm(char **xpm, unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, int x1, int x2, int y1, int y2)
{
	/* order values */
	if(y1>y2)
	{
		int a;

		a=y2;
		y2=y1;
		y1=a;
	}

	/* clip coordinates */
	if(y1<0)
		y1=0;
	if(y2>=xpm_height)
		y2=xpm_height-1;

	/* order values */
	if(x1>x2)
	{
		int a;

		a=x2;
		x2=x1;
		x1=a;
	}

	/* clip coordinates */
	if(x1<0)
		x1=0;
	if(x2>=xpm_width)
		x2=xpm_width-1;

	x2=(x2-x1)+1;		/* x2 becomes the line width */
	if(x2>0)
	{
		while(y1<y2)
		{
			memset(&xpm[array_offset_to_pix+y1][x1],color_char,x2);
			y1++;
		}
	}
}

static inline void plot_xpm(char **xpm, unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, int x, int y)
{
	if((x<0)||(x>=xpm_width))
		return;
	if((y<0)||(y>=xpm_height))
		return;

	xpm[array_offset_to_pix+y][x]=color_char;
}

/*********************/
/* draw a cyclic box */
/*********************/
void cyclic_box_xpm(char **xpm, unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, float min_range, float max_range, int x1,int x2, int y1, int y2)
{
	int dx,dy;
	float surface;
	int x_start,y_start;
	int x_end,y_end;

	/* order values */
	if(y1>y2)
	{
		int a;

		a=y2;
		y2=y1;
		y1=a;
	}

	/* clip coordinates */
	if(y1<0)
		y1=0;
	if(y2>=xpm_height)
		y2=xpm_height-1;

	/* order values */
	if(x1>x2)
	{
		int a;

		a=x2;
		x2=x1;
		x1=a;
	}

	/* clip coordinates */
	if(x1<0)
		x1=0;
	if(x2>=xpm_width)
		x2=xpm_width-1;

	if(min_range>max_range)
	{
		float a;

		a=max_range;
		max_range=min_range;
		min_range=a;
	}

	if(min_range<0.0)
		min_range=0.0;
	if(max_range>1.0)
		max_range=1.0;

	dx=x2-x1;
	if(dx)
	{
		dy=y2-y1;
		if(dy)
		{
			dx++;
			dy++;

			surface=dx*dy;

			min_range*=surface;
			max_range*=surface;

			x_start=min_range/dy;
			y_start=min_range-x_start*dy;

			x_end=max_range/dy;
			y_end=max_range-x_end*dy;

			/* invert y coordinates */
			dy--;
			y_start=dy-y_start;
			y_end=dy-y_end;

			while(x_start<x_end)
			{
				plot_xpm(xpm, xpm_width, xpm_height, array_offset_to_pix, color_char, x1+x_start, y1+y_start);
				y_start--;
				if(y_start<0)
				{
					y_start=dy;
					x_start++;
				}
			}

			while(y_start>y_end)		/* because y axis is inverted, it is not start<end but start>end */
			{
				plot_xpm(xpm, xpm_width, xpm_height, array_offset_to_pix, color_char, x1+x_start, y1+y_start);
				y_start--;
			}
		}
	}

}

