/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * unode_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: unode_clist.c,v 1.5 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "unode_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "unode.h"
#include "init_fnc.h"

/**********************************/
/* reload the unode clist content */
/**********************************/
void reload_unode_clist(int only_if_empty)
{
	GtkWidget *w;
	w=get_widget_by_widget_name(main_window,"unode_clist");
	if(w)
	{
		GtkListStore *gls;
		GtkTreeIter iter;
		GtkTreeModel *gtm;

		gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

		if((only_if_empty==0)&&gtk_tree_model_is_not_empty(gtm))
			return;

		gtk_list_store_clear(gls);

		G_LOCK(unode_lmp);
		if(!lmp_lock_and_map(unode_lmp))
		{
			int i;
			UNODE_DATA *ulm=unode_lmp->mapped_addr;

			for(i=1;i<unode_lmp->nb_records;i++)	/* skip the first record */
			{
				UNODE_DATA *udt=&(ulm[i]);
			
				if(udt->entry_enabled)
				{
					gtk_list_store_append(gls,&iter);
					gtk_list_store_set(gls,&iter,UNC_UNODE_ADDR_COL,udt->host_unresolved_addr,-1);
				}
			}
			lmp_unmap_and_unlock(unode_lmp);
		}
		G_UNLOCK(unode_lmp);
	}
}

/********************************************/
/* build model and view for the unode clist */
/********************************************/
void bmav4_unode_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_UNC_COL,G_TYPE_STRING);

	view=get_widget_by_widget_name(main_window,"unode_clist");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UNC_UNODE_ADDR_COL,_("Remote Unode Address"),rend,"text",UNC_UNODE_ADDR_COL,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

