<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="org.apache.xalan.lib.Redirect"
    extension-element-prefixes="redirect">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:param name="TestDocDir">.</xsl:param>
  <xsl:variable name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
  <xsl:include href="DashboardConfig.xsl"/>
  <!--
	Set the output method to html.  This style sheet outputs both html
	and possibly base64 files.  The html output method is incorrect for
	the base64 files but it does not seem to impact the conversions.
	If the output method is xml, then a standard xml header is created and
	we cannot decode the base64 file. 
	-->	
  <xsl:output method="html"/> 

  <xsl:template match="/">
    <xsl:call-template name="Summary"/>
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Test Log <xsl:value-of select="/Site/@Name"/> -- <xsl:value-of select="/Site/@BuildName"/></xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>
    <h2>Testing started on <xsl:value-of select="Site/Testing/StartDateTime"/></h2>
    <p>
      <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
    </p>
    <p>
      <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
    </p>
    <br/>
    <h3>
      <xsl:value-of select="count(Site/Testing/Test[@Status='passed'])"/> passed, 
      <xsl:value-of select="count(Site/Testing/Test[@Status='failed'])"/> failed,
      <xsl:value-of select="count(Site/Testing/Test[@Status='notrun'])"/> not run
    </h3>
    <br/>
    <table cellspacing="0">
      <tr>
        <th>Name</th>
        <th>Status</th>
        <th>Detail</th>
      </tr>
      <xsl:for-each select="Site/Testing/Test">
        <xsl:sort select="@Status='notrun'" order="descending"/>
        <xsl:sort select="@Status='failed'" order="descending"/>
        <xsl:sort select="@Status='passed'" order="descending"/>
        <xsl:sort select="Name" order="ascending"/>
        <xsl:if test="@Status='notrun'">
         <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">tr-even</xsl:attribute>
          </xsl:if>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix"><xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:value-of select="Name"/>
            </a>
          </td>
          <td>
            <xsl:attribute name="class">error</xsl:attribute>
            Not Run
          </td>
          <td></td>
         </tr>
        </xsl:if>
        <xsl:if test="@Status='failed'">
         <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">tr-even</xsl:attribute>
          </xsl:if>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix"><xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute><xsl:value-of select="Name"/>
            </a>
          </td>
          <td>
            <xsl:attribute name="class">warning</xsl:attribute>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">Results/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
                Failed
            </a>
          </td>
          <td>
            <xsl:choose>
               <xsl:when test="Results/NamedMeasurement[@name='Completion Status'] = 'Timeout'">
                   Timeout
               </xsl:when>
               <xsl:when test="Results/NamedMeasurement[@name='Exit Code']">
                <xsl:value-of select="Results/NamedMeasurement[@name='Exit Code']"/>
               </xsl:when>
            </xsl:choose>
          </td>
         </tr>
        </xsl:if>
        <xsl:if test="@Status='passed'">
         <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">tr-even</xsl:attribute>
          </xsl:if>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix"><xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:value-of select="Name"/>
            </a>
          </td>
          <td>
            <xsl:attribute name="class">pass</xsl:attribute>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">Results/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
                Passed
            </a>
          </td>
          <td></td>
         </tr>
        </xsl:if>
      </xsl:for-each>
    </table>
    
    <xsl:for-each select="//Testing/Test">
      <xsl:call-template name="Test"/>
    </xsl:for-each>

    <xsl:call-template name="DashboardFooter">
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>

  </xsl:template>
    
  <xsl:template name="Test">
      <redirect:write select="concat(string('{$TestDocDir}'), '/Results/', translate ( FullName, '/.', '__' ) , '.html' )" file="dan.html">
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Test results for <xsl:value-of select="Name"/></xsl:with-param>
        <xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
        <xsl:with-param name="DashboardDir">../<xsl:value-of select="$DashboardDir"/></xsl:with-param>
      </xsl:call-template>
      <p>
        <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
      </p>
      <p>
        <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
      </p>
      <a>
        <xsl:attribute name="href">
          <xsl:call-template name="TranslateTestName">
            <xsl:with-param name="Prefix">../<xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
            <xsl:with-param name="TestName" select="FullName"/>
            <xsl:with-param name="Postfix">.html</xsl:with-param>
          </xsl:call-template>
        </xsl:attribute>
        <xsl:value-of select="Name"/> 
      </a>
      <xsl:choose>
        <xsl:when test="contains('failed',@Status)">
          <font>
            <xsl:attribute name="color"><xsl:value-of select="$WarningColor"/></xsl:attribute>
            Failed
          </font>
        </xsl:when>
        <xsl:when test="contains('passed',@Status)">
          <font>
            <xsl:attribute name="color"><xsl:value-of select="$NormalColor"/></xsl:attribute>
            Passed
          </font>
        </xsl:when>
      </xsl:choose>
	
      <br/><br/><br/>
      <table>
        <xsl:for-each select="Results/NamedMeasurement">
	  <xsl:sort select="@type"/>
	  <xsl:sort select="@name"/>
          <xsl:call-template name="NamedMeasurements"/>
        </xsl:for-each>
      </table>
      <br/><br/><br/>
      <b>Test output</b>
      <pre>
        <xsl:value-of select="Results/Measurement/Value" disable-output-escaping="yes"/>
      </pre>
      <xsl:call-template name="DashboardFooter">
	<xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
      </xsl:call-template>
    </redirect:write>
  </xsl:template>
    
<xsl:template name="NamedMeasurements">
   <tr>
     <th><xsl:attribute name="class">measurement</xsl:attribute><xsl:value-of select="@name"/></th>
     <td>
       <xsl:choose>
	  <xsl:when test="contains(@type,'numeric') or contains(@type,'text/string')">
	     <xsl:value-of select="Value"/>
	  </xsl:when>

	  <xsl:when test="contains(@type,'link/url')">
	     <a><xsl:attribute name="href"><xsl:value-of select="Value"/></xsl:attribute><xsl:value-of select="Value"/></a>
	  </xsl:when>

	  <xsl:when test="contains(@type,'link/image')">
	     <img><xsl:attribute name="src"><xsl:value-of select="Value"/></xsl:attribute><xsl:value-of select="Value"/></img>
	  </xsl:when>

	  <xsl:when test="contains(@type,'image/png') and contains(@encoding,'base64')">
             <redirect:write select="concat(string('{$TestDocDir}'), '/Results/', translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.png.base64' )" file="dan.html">
  	       <xsl:value-of select="Value"/>
	     </redirect:write>
	     <img><xsl:attribute name="src"><xsl:value-of select="concat(translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.png' )"/></xsl:attribute></img>
	  </xsl:when>
	  <xsl:when test="contains(@type,'image/jpeg') and contains(@encoding,'base64')">
             <redirect:write select="concat(string('{$TestDocDir}'), '/Results/', translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.jpg.base64' )" file="dan.html">
  	       <xsl:value-of select="Value"/>
	     </redirect:write>
	     <img><xsl:attribute name="src"><xsl:value-of select="concat(translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.jpg' )"/></xsl:attribute></img>
	  </xsl:when>
       </xsl:choose>	
     </td>
   </tr>
</xsl:template>

<xsl:template name="Summary">
  <redirect:write select="concat(string('{$TestDocDir}'), '/TestSummary.xml' )">
    <Testing>
      <SiteName><xsl:value-of select="Site/@Name"/></SiteName>
      <BuildName><xsl:value-of select="Site/@BuildName"/></BuildName>
      <BuildStamp><xsl:value-of select="Site/@BuildStamp"/></BuildStamp>
      <StartDateTime><xsl:value-of select="Site/Testing/StartDateTime"/></StartDateTime>
      
      <PassedCount><xsl:value-of select="count(Site/Testing/Test[@Status='passed'])"/></PassedCount>
      <FailedCount><xsl:value-of select="count(Site/Testing/Test[@Status='failed'])"/></FailedCount>
      <NotRunCount><xsl:value-of select="count(Site/Testing/Test[@Status='notrun'])"/></NotRunCount>
      <EndDateTime><xsl:value-of select="Site/Testing/EndDateTime"/></EndDateTime>
      <Tests>
        <xsl:for-each select="Site/Testing/Test">
            <Test>
              <FullName><xsl:value-of select="FullName"/></FullName>
              <Status><xsl:value-of select="@Status"/></Status>
              <xsl:if test="Results/NamedMeasurement[@name='Completion Status']">
                 <CompletionStatus><xsl:value-of select="Results/NamedMeasurement[@name='Completion Status']"/></CompletionStatus>
              </xsl:if>
              <xsl:if test="Results/NamedMeasurement[@name='Exit Code']">
                 <ExitCode><xsl:value-of select="Results/NamedMeasurement[@name='Exit Code']"/></ExitCode>
              </xsl:if>
            </Test>
        </xsl:for-each>
      </Tests>
    </Testing>
  </redirect:write>
</xsl:template>

</xsl:stylesheet>
  
