/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.NodeList;

public class XRTreeFrag
extends XObject
implements Cloneable {
    DTM m_dtm;
    int m_dtmRoot;
    XPathContext m_xctxt;
    boolean m_allowRelease = true;
    private XMLString m_xmlStr = null;

    public XRTreeFrag(int n, XPathContext xPathContext) {
        super(null);
        this.m_dtmRoot = n;
        this.m_xctxt = xPathContext;
        this.m_dtm = xPathContext.getDTM(n);
    }

    public XRTreeFrag(Expression expression) {
        super(expression);
    }

    public void allowDetachToRelease(boolean bl) {
        this.m_allowRelease = bl;
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        XString xString = (XString)this.xstr();
        xString.appendToFsb(fastStringBuffer);
    }

    public DTMIterator asNodeIterator() {
        return this.m_xctxt.createDTMIterator(this.m_dtmRoot);
    }

    public boolean bool() {
        return true;
    }

    public NodeList convertToNodeset() {
        if (this.m_obj instanceof NodeList) {
            return (NodeList)this.m_obj;
        }
        return new DTMNodeList(this.asNodeIterator());
    }

    public void destruct() {
        if (this.m_dtm != null) {
            this.m_xctxt.release(this.m_dtm, true);
            this.m_dtm = null;
            this.m_xctxt = null;
        }
        this.m_obj = null;
    }

    public void detach() {
        if (this.m_allowRelease) {
            if (this.m_dtm != null) {
                this.m_xctxt.release(this.m_dtm, true);
                this.m_dtm = null;
                this.m_xctxt = null;
            }
            this.m_obj = null;
        }
    }

    public boolean equals(XObject xObject) {
        try {
            if (xObject.getType() == 4) {
                return xObject.equals(this);
            }
            if (xObject.getType() == 1) {
                return this.bool() == xObject.bool();
            }
            if (xObject.getType() == 2) {
                return this.num() == xObject.num();
            }
            if (xObject.getType() == 4) {
                return this.xstr().equals(xObject.xstr());
            }
            if (xObject.getType() == 3) {
                return this.xstr().equals(xObject.xstr());
            }
            if (xObject.getType() == 5) {
                return this.xstr().equals(xObject.xstr());
            }
            return super.equals(xObject);
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            Object var2_1 = null;
            super.finalize();
        }
    }

    public int getType() {
        return 5;
    }

    public String getTypeString() {
        return "#RTREEFRAG";
    }

    public double num() throws TransformerException {
        XMLString xMLString = this.xstr();
        return xMLString.toDouble();
    }

    public Object object() {
        return new DTMNodeIterator(new NodeSetDTM(this.m_dtmRoot, this.m_xctxt.getDTMManager()));
    }

    public int rtf() {
        return this.m_dtmRoot;
    }

    public String str() {
        String string = this.m_dtm.getStringValue(this.m_dtmRoot).toString();
        return string == null ? "" : string;
    }

    public XMLString xstr() {
        if (this.m_xmlStr == null) {
            this.m_xmlStr = this.m_dtm.getStringValue(this.m_dtmRoot);
        }
        return this.m_xmlStr;
    }
}

