
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#ifndef __PROTO_H
#define __PROTO_H

#include "bignum.h"
#include <stdio.h>

extern int64 proto_in[256], proto_out[256], proto_other[256];

#define proto_transfer_in(proto, amount) i64add32(proto_in[proto], amount)
#define proto_transfer_out(proto, amount) i64add32(proto_out[proto], amount)
#define proto_transfer_other(proto, amount) i64add32(proto_other[proto], amount)

void proto_db_init(void);
void proto_db_save(FILE *fp);
int proto_db_load(FILE *fp);

const char *proto_name(const byte protocol);
const char *proto_name_short(const byte protocol);

#endif
