

#include <windows.h>
#include <mapi.h>
#include <stdio.h>

#include "send_email.h"

ULONG get_recipient(const char *name, ULONG recipClass, lpMapiRecipDesc *desc);

int send_email(const char *sendname, 
               const char *recvname, 
               const char *ccname, 
               const char *subj,
               const char *body,
               const char *path)
{
    FLAGS flags;
    MapiMessage msg;
    ULONG send_res;
    MapiRecipDesc *orig, *recip, *cc;
    int num_recip = 1, return_code = -1;
    MapiFileDesc attachment;
    MapiFileTagExt file_type;
    const char *filename;

    orig = recip = cc = NULL;
    
    if (get_recipient(sendname, MAPI_ORIG, &orig) != SUCCESS_SUCCESS) {
        goto cleanup;
    }

    if (get_recipient(recvname, MAPI_TO, &recip) != SUCCESS_SUCCESS) {
        goto cleanup;
    }
    
    if (ccname && strlen(ccname) > 0) {
        if (get_recipient(ccname, MAPI_CC, &cc) != SUCCESS_SUCCESS) {
            goto cleanup;
        }
        num_recip++;
    }

    memset(&msg, 0, sizeof(msg));
    msg.lpOriginator = orig;
    msg.lpRecips = recip;
    msg.lpszMessageType = "text/plain";
    msg.lpszNoteText = (LPSTR) body;
    msg.lpszSubject = (LPSTR)subj;
    msg.nRecipCount = num_recip;
    msg.flFlags = 0;

    if (path) {
        filename = strrchr(path, '/');
        if (filename == 0)
            filename = strrchr(path, '\\');
        if (filename == 0)
            filename = path;
        else
            filename++;
        memset(&attachment, 0, sizeof(attachment));
        attachment.nPosition = -1;
        attachment.lpszPathName = (LPTSTR)path;
        attachment.lpszFileName = (LPTSTR)filename;

        attachment.lpFileType = &file_type;
        
        memset(&file_type, 0, sizeof(file_type));
        file_type.lpTag = "text/plain";
        file_type.cbTag = sizeof(file_type.lpTag);

        msg.nFileCount = 1;
        msg.lpFiles = &attachment;
    }

    flags = 0;
    send_res = MAPISendMail(0, 0, &msg, flags, 0);

    if (send_res != SUCCESS_SUCCESS) {
        fprintf(stderr, "MAPISendMail returned %ld\n", send_res);
        goto cleanup;
    }

    return_code = 0;
    
  cleanup:
    if (orig) MAPIFreeBuffer(orig);
    if (recip) MAPIFreeBuffer(recip);
    if (cc) MAPIFreeBuffer(cc);

    return return_code;
}

ULONG get_recipient(const char *name, ULONG recipClass, lpMapiRecipDesc *desc) {
    ULONG ret = MAPIResolveName(0, 0, (LPSTR) name, 0, 0, desc);
    if (ret != SUCCESS_SUCCESS) {
        fprintf(stderr, "MAPIResolveName could not resolve '%s'\n", name);
    } else {
        (*desc)->ulRecipClass = recipClass;
    }
    return ret;
}
