/* termcap.h					-*- C++ -*-
   $Id: termcap.h,v 1.15 2001/11/27 23:57:36 elf Exp $
   
   written by Marc Singer
   20 Dec 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   Direct termcap support.  Sorry ncurses folks.

*/

#if !defined (__TERMCAP_H__)
#    define   __TERMCAP_H__

/* ----- Includes */

#include <stdarg.h>

/* ----- Globals */

typedef enum {
  termcapClassNul		= 0,
  termcapClassBoolean		= 0x01,
  termcapClassNumber		= 0x02,
  termcapClassString		= 0x03,
  termcapClassMethod		= 0x04,
  termcapClassKey		= 0x05,
  termcapClassStringMap		= 0x06,	// Use for ACS map
  termcapClassMask		= 0x0f,
  termcapInhibit		= 0x80,
} eTermcapFlags;

				// This must change since we cannot
				// assumes characters are not 16
				// bits. 
#define KEYCODE(c)		(0x8000 | unsigned (c))

#define USE_TERMCAPNAME

#define __(i,s,t,o,f) i,
typedef enum {
  termcapCloseMatch = -1,	// Used for key matching
# include "termcap.f"
} eTermcap;
#undef __

typedef struct {
  int id;			// Our identifier for the termcap field
  char sz[3];
  int flags;
  int index;			// Termcap entry index
#if defined (USE_TERMCAPNAME)
  char* szName;
#endif
  void* pv;
} TERMCAP_FIELD;

class Termcap {
protected:
  static bool g_fValid;
  static bool g_fActive;
  static bool g_fTerminfo;	// Using terminfo, not termcap (necessary?)
  static TERMCAP_FIELD g_rgTermcapField[];
  static void* g_pvTerminfo;	// Terminfo source data

  static int g_cLines;		// Screen size, zeroes when not a tty
  static int g_cColumns;

				// -- Termcap access methods
  bool _is_tc (void) {
    return g_pvTerminfo ? true : false; }
  unsigned char* _tc_pb (void) {
    return (unsigned char*) g_pvTerminfo; }
  unsigned char _tc_b (int ib) {
    return *((unsigned char*)g_pvTerminfo + ib); }
  short _tc_w (int ib) {
    return *((unsigned char*)g_pvTerminfo + ib)
      | (*((unsigned char*)g_pvTerminfo + ib + 1) << 8); }
  short _tc_cb_names (void) {
    return _tc_w (2); }
  short _tc_c_boolean (void) {
    return _tc_w (4); }
  short _tc_c_num (void) {
    return _tc_w (6); }
  short _tc_c_strings (void) {
    return _tc_w (8); }
  short _tc_cb_strings (void) {
    return _tc_w (10); }
  short _tc_cb_header (void) {
    return 2*6; }
  short _tc_ib_boolean (void) {
    return _tc_cb_header () + _tc_cb_names (); }
  short _tc_ib_num (void) {
    return (_tc_ib_boolean () + _tc_c_boolean () + 1) & ~0x1; }
  short _tc_ib_strings (void) {
    return _tc_ib_num () + _tc_c_num ()*2; }
  short _tc_ib_string_table (void) {
    return _tc_ib_strings () + _tc_c_strings ()*2; }
  bool _tc_boolean (int i) {
    return _tc_b (_tc_ib_boolean () + i) ? true : false; }
  short _tc_num (int i) {
    return _tc_w (_tc_ib_num () + i*2); }
  char* _tc_string (int i) {
    short ib = _tc_w (_tc_ib_strings () + i*2);
    return (char*) ((ib == -1) 
		    ? NULL
		    : (_tc_pb () + _tc_ib_string_table () + ib)); }

  int _compose_c (int method, char* pb, va_list ap) const; // termcap  rules
  int _compose_i (int method, char* pb, va_list ap) const; // terminfo (GNU)
  TERMCAP_FIELD* locate (int id) const {
    return &g_rgTermcapField[id]; }

public:
  Termcap () {
    zero (); }
  ~Termcap () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (void);		// Class initialization
  void activate (bool fActive);
  void release_this (void);

  int parse_field (void* pv);	// Parse a termcap field
  void interpret_termcap_string (char* sz, const char* szSrc, int cch);
  bool parse_termcap (const char* szTerm);
  bool parse_terminfo (const char* szTerm);

  bool has (int id) const {
    TERMCAP_FIELD* pField = locate (id);
    return pField && pField->pv; }
  bool is (int id) const {
    TERMCAP_FIELD* pField = locate (id);
    return pField && pField->flags == termcapClassBoolean && pField->pv; }
  int compose (int method, char* pb, ...) const;
  
  int translate (int field, char* pb, const char* szSource);
  int num (int field);
  int keyof (const char* rgb, size_t cch);

};

#endif  /* __TERMCAP_H__ */
