/* -*- mode: c; c-file-style: "gnu" -*-
 * primes.h -- initial DH primes for CryWrap
 * Copyright (C) 2003 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of CryWrap.
 *
 * CryWrap is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CryWrap is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file primes.h
 * Initial DH primes for CryWrap.
 *
 * In order to speed up the startup time, CryWrap does not generate a
 * new DH prime upon every startup, but only when it receives a
 * SIGHUP.
 */

#ifndef _CRYWRAP_PRIMES_H
#define _CRYWRAP_PRIMES_H /**< primes.h multi-include guard */

/** Initial DH primes, 1024 bits.
 */
static unsigned char _crywrap_prime_dh_1024[] = {
  0xA0,0xB8,0x8C,0xB3,0x7B,0x22,0xBB,0xEC,0xBF,0x28,0x90,0xAA,
  0xF3,0x32,0x2B,0xFE,0xDB,0x9B,0xC4,0xA8,0x98,0xF1,0x88,0x2A,
  0x9A,0x9C,0xE2,0x21,0xB5,0x82,0x6D,0xE5,0x28,0x7F,0xD5,0xE9,
  0x8F,0x89,0xDA,0x10,0x87,0x32,0x08,0x13,0xCB,0x1B,0x23,0x3F,
  0x12,0x52,0x78,0x16,0x05,0xC5,0x6F,0xFC,0xDC,0x23,0xB9,0xA9,
  0x8C,0x80,0xFB,0x26,0x70,0x65,0x20,0x8E,0xAC,0xBD,0xF6,0x0F,
  0xEE,0xF1,0x51,0xE0,0x48,0xDD,0xF4,0xE3,0xF0,0x41,0x4C,0x7C,
  0x09,0xE9,0x9E,0xCB,0x94,0x79,0x59,0x0C,0xCC,0xF2,0xAB,0x8F,
  0xCD,0x07,0xC0,0xBB,0x61,0x9D,0x8D,0xA3,0x0F,0x63,0x08,0x53,
  0x89,0xA1,0x42,0x02,0x0C,0x9C,0x9D,0xEB,0x1C,0x28,0x67,0x75,
  0x57,0x52,0x42,0x96,0x47,0xC6,0xFE,0xBB
};
/** DH generator.
 */
static unsigned char _crywrap_generator_dh[]={ 0x02 };

#endif

/* arch-tag: a5ef5d07-d423-41fc-a2f3-360d47470df3 */
