/* ui_callbacks.c - Definition of UI callbacks
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank.h"

/* External functions and variables */
extern char *text;
extern GtkWidget *textarea;
extern GtkWidget *sourcearea;
extern GtkWidget *hbox2;
extern GtkWidget *label_source_area;
extern int displaying_sourcearea;
extern plugin_data *current_plugin;

GtkWidget *make_OK_box(const char *text);
int do_load (char *filename);
int do_save (char *filename);
void do_break(void);
GtkWidget *make_source_edit_dialog(void);
void display_text(void);
void display_source_text(void);

/* Empty the source text */
void cb_clear_source(void) {
    free(text);
    text = malloc(sizeof(char));
    text[0] = '\0';
    display_source_text();
    display_text();
}

/* Change some of the source */
void cb_source_change(GtkEditable *editable, gpointer user_data) {
    free(text);
    text = gtk_editable_get_chars(GTK_EDITABLE(sourcearea), 0, -1);
    display_text();
}

/* Hide / show source view */
void cb_toggle_source_view(void) {
    if (displaying_sourcearea) {
	gtk_widget_hide(hbox2);
	gtk_widget_hide(label_source_area);
    } else {
	gtk_widget_show(hbox2);
	gtk_widget_show(label_source_area);
    }
    TOGGLE(displaying_sourcearea);
}

/* Make source = view */
void cb_set_source_from_view(GtkWidget *widget, gpointer gdata) {
    free(text);
    text = gtk_editable_get_chars(GTK_EDITABLE(textarea), 0, -1);
    current_plugin->reset();
    display_text();
    display_source_text();
}

/* Help - about */
void cb_about(GtkWidget *widget, gpointer gdata) {
    gtk_widget_show(make_OK_box(STR_ABOUT));
}


/*  File Request Dialog Callbacks */
void cb_open(GtkWidget *widget, GtkFileSelection *fselection) {
    if (!do_load(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fselection))))
	gtk_widget_show(make_OK_box("ERROR: Unable to find or open file."));
    current_plugin->reset();
    display_text();
    display_source_text();
}

void cb_save(GtkWidget *widget, GtkFileSelection *fselection) {
    if (!do_save(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fselection))))
      gtk_widget_show(make_OK_box("ERROR: Unable to save to file."));
    display_text();
}

/* Menu callbacks */
void cb_start_open (GtkWidget *widget, gpointer gdata) {
    GtkWidget *fopener;
    fopener = gtk_file_selection_new("Get source text");
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION (fopener)->cancel_button),
			      "clicked",
			      (GtkSignalFunc) gtk_widget_destroy,
			      GTK_OBJECT(fopener));
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fopener)->ok_button),
		       "clicked",
		       (GtkSignalFunc) cb_open,
		       GTK_OBJECT(fopener));
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION (fopener)->ok_button),
			      "clicked",
			      (GtkSignalFunc) gtk_widget_destroy,
			      GTK_OBJECT(fopener));
    gtk_widget_show(fopener);
    
}

void cb_start_save (GtkWidget *widget, gpointer gdata) {
    GtkWidget *fopener;
    fopener = gtk_file_selection_new("Save viewed text");
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION (fopener)->cancel_button),
			      "clicked",
			      (GtkSignalFunc) gtk_widget_destroy,
			      GTK_OBJECT(fopener));
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fopener)->ok_button),
		       "clicked",
		       (GtkSignalFunc) cb_save,
		       GTK_OBJECT(fopener));
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION (fopener)->ok_button),
			      "clicked",
			      (GtkSignalFunc) gtk_widget_destroy,
			      GTK_OBJECT(fopener));
    gtk_widget_show(fopener);
}

void cb_exit_crank (GtkWidget *widget, gpointer gdata) {
      gtk_main_quit();
}
