/* files.c - File i/o functions
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank.h"

/* External functions and variables */
extern char *text;
GtkWidget *textarea;

/* Load file into source */
int do_load (char *filename) {
    FILE *inf;
    int c;
    int i = 0;
    int count = 0;
    inf = fopen(filename, "r");
    if (!inf)
	return FALSE;
    
    /* Calculate size of file */
    while (getc(inf) != EOF)
	count++;
    fseek(inf, 0, 0);
    rewind(inf);

    free(text);
    text = malloc((count + 1) * sizeof(char));

    while ( (c = getc(inf)) != EOF)
	text[i++] = c;
    text[i] = '\0';

    fclose(inf);
    return TRUE;
}

/* Save transformed text */
int do_save (char *filename) {
    FILE *otf;
    int i = 0;
    char *buf;
    otf = fopen(filename, "w");
    if (!otf)
	return FALSE;

    buf = GLOBAL_TRANSFORMED_TEXT;
    while (buf[i] != '\0')
	putc(buf[i++], otf);
    g_free(buf);

    fclose(otf);
    return TRUE;
}
