/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      AppIcon : NSObject
 *
 *  Description:  Application's icon window. Used to draw PPP load graphics
 *                and showing status of connection.
 */

#import <Foundation/NSObject.h>
#import <AppKit/NSView.h>

#define PPPOffMode   0
#define PPPOnMode    1
#define PPPStatsMode 2

@class NSImage;
@class NSCell;
@class NSTimer;

@interface AppIcon : NSView
{
  NSCell  *dragCell;
  NSCell  *tileCell;

  NSImage *tileImage;
  NSImage *onImage;
  NSImage *offImage;
  NSImage *maskImage;

  NSTimer *drawStatsTimer;

  int     currentMode;
}

- (void) setMode: (int)mode;

@end

