;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:     clsql-uffi-loader.sql
;;;; Purpose:  Library loader using CLSQL UFFI helper library
;;;; Author:   Kevin M. Rosenberg
;;;; Created:  Mar 2002
;;;;
;;;; $Id: clsql-uffi-loader.lisp 10115 2004-10-24 04:32:58Z kevin $
;;;;
;;;; This file, part of CLSQL, is Copyright (c) 2002-2004 by Kevin M. Rosenberg
;;;;
;;;; CLSQL users are granted the rights to distribute and use this software
;;;; as governed by the terms of the Lisp Lesser GNU Public License
;;;; (http://opensource.franz.com/preamble.html), also known as the LLGPL.
;;;; *************************************************************************

(in-package #:clsql-uffi)

(defvar *clsql-uffi-library-filename* 
  (uffi:find-foreign-library
   '(#+64bit "uffi64" "uffi")
   `(,clsql-uffi-system::*library-file-dir*
     "/usr/lib/clsql/")
   :drive-letters '("C")))

(defvar *clsql-uffi-supporting-libraries* '("c")
  "Used only by CMU. List of library flags needed to be passed to ld to
load the MySQL client library succesfully.  If this differs at your site,
set to the right path before compiling or loading the system.")

(defvar *uffi-library-loaded* nil
  "T if foreign library was able to be loaded successfully")

(defun load-uffi-foreign-library ()
  (unless (probe-file *clsql-uffi-library-filename*)
    (error "Unable to find uffi.so"))
  
  (if (uffi:load-foreign-library *clsql-uffi-library-filename* 
				 :module "clsql-uffi" 
				 :supporting-libraries 
				 *clsql-uffi-supporting-libraries*)
      (setq *uffi-library-loaded* t)
    (error "Unable to load helper library ~A" *clsql-uffi-library-filename*)))

(load-uffi-foreign-library)

