;;; -*- Mode: Lisp -*-
;;; $Id: test-time.lisp,v 1.3 2003/03/24 22:18:48 adam Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.
;;;
;;; Test time functions (time.lisp and iso-8601.lisp)

(in-package :odcl)

(defregression (:time 1)
  "relations of intervals"
  (let* ((time-1 (parse-timestring "2002-01-01 10:00:00"))
         (time-2 (parse-timestring "2002-01-01 11:00:00"))
         (time-3 (parse-timestring "2002-01-01 12:00:00"))
         (time-4 (parse-timestring "2002-01-01 13:00:00"))
         (interval-1 (make-interval :start time-1 :end time-2))
         (interval-2 (make-interval :start time-2 :end time-3))
         (interval-3 (make-interval :start time-3 :end time-4))
         (interval-4 (make-interval :start time-1 :end time-3))
         (interval-5 (make-interval :start time-2 :end time-4))
         (interval-6 (make-interval :start time-1 :end time-4)))
    (flet ((my-assert (number relation i1 i2)
             (let ((found-relation (interval-relation i1 i2)))
               (unless (equal relation found-relation)
                 (error "Assert # ~d: relation of ~s to ~s is ~s, should be ~s" number i1 i2 found-relation relation)))))
      (my-assert 1 :contains interval-1 interval-1)
      (my-assert 2 :precedes interval-1 interval-2)
      (my-assert 3 :precedes interval-1 interval-3)
      (my-assert 4 :contained interval-1 interval-4)
      (my-assert 5 :precedes interval-1 interval-5)
      (my-assert 6 :contained interval-1 interval-6)
      (my-assert 7 :follows interval-2 interval-1)
      (my-assert 8 :contains interval-2 interval-2)
      (my-assert 9 :precedes interval-2 interval-3)
      (my-assert 10 :contained interval-2 interval-4)
      (my-assert 11 :contained interval-2 interval-5)
      (my-assert 12 :contained interval-2 interval-6)
      (my-assert 13 :follows interval-3 interval-1)
      (my-assert 14 :follows interval-3 interval-2)
      (my-assert 15 :contains interval-3 interval-3)
      (my-assert 16 :follows interval-3 interval-4)
      (my-assert 17 :contained interval-3 interval-5)
      (my-assert 18 :contained interval-3 interval-6)
      (my-assert 19 :contains interval-4 interval-1)
      (my-assert 20 :contains interval-4 interval-2)
      (my-assert 21 :precedes interval-4 interval-3)
      (my-assert 22 :contains interval-4 interval-4)
      (my-assert 23 :overlaps interval-4 interval-5)
      (my-assert 24 :contained interval-4 interval-6)
      (my-assert 25 :follows interval-5 interval-1)
      (my-assert 26 :contains interval-5 interval-2)
      (my-assert 27 :contains interval-5 interval-3)
      (my-assert 28 :overlaps interval-5 interval-4)
      (my-assert 29 :contains interval-5 interval-5)
      (my-assert 30 :contained interval-5 interval-6)
      (my-assert 31 :contains interval-6 interval-1)
      (my-assert 32 :contains interval-6 interval-2)
      (my-assert 33 :contains interval-6 interval-3)
      (my-assert 34 :contains interval-6 interval-4)
      (my-assert 35 :contains interval-6 interval-5)
      (my-assert 36 :contains interval-6 interval-6))))

(defregression (:time 2)
  "adjacent intervals in list"
  (let* ((interval-list nil)
         (time-1 (parse-timestring "2002-01-01 10:00:00"))
         (time-3 (parse-timestring "2002-01-01 12:00:00"))
         (time-4 (parse-timestring "2002-01-01 13:00:00")))
    (setq interval-list (interval-push interval-list (make-interval :start time-1 :end time-3 :type :open)))
    (setq interval-list (interval-push interval-list (make-interval :start time-3 :end time-4 :type :open)))))

(defregression (:time 3)
  "nested intervals in list"
  (let* ((interval-list nil)
         (time-1 (parse-timestring "2002-01-01 10:00:00"))
         (time-2 (parse-timestring "2002-01-01 11:00:00"))
         (time-3 (parse-timestring "2002-01-01 12:00:00"))
         (time-4 (parse-timestring "2002-01-01 13:00:00")))
    (setq interval-list (interval-push interval-list (make-interval :start time-1 :end time-4 :type :open)))
    (setq interval-list (interval-push interval-list (make-interval :start time-2 :end time-3 :type :closed)))))

(defregression (:time 4)
  "interval-edit 1 - nonoverlapping"
  (let* ((interval-list nil)
         (time-1 (parse-timestring "2002-01-01 10:00:00"))
         (time-2 (parse-timestring "2002-01-01 11:00:00"))
         (time-3 (parse-timestring "2002-01-01 12:00:00"))
         (time-4 (parse-timestring "2002-01-01 13:00:00")))
    (setq interval-list (interval-push interval-list (make-interval :start time-1 :end time-2 :type :open)))
    (setq interval-list (interval-push interval-list (make-interval :start time-3 :end time-4 :type :closed)))
    (setq interval-list (interval-edit interval-list time-1 time-1 time-3))))

(defregression (:time 5)
  "interval-edit 1 - overlapping"
  (let* ((interval-list nil)
         (time-1 (parse-timestring "2002-01-01 10:00:00"))
         (time-2 (parse-timestring "2002-01-01 11:00:00"))
         (time-3 (parse-timestring "2002-01-01 12:00:00"))
         (time-4 (parse-timestring "2002-01-01 13:00:00")))
    (setq interval-list (interval-push interval-list (make-interval :start time-1 :end time-2 :type :open)))
    (setq interval-list (interval-push interval-list (make-interval :start time-2 :end time-4 :type :closed)))
    (odcl::expect-error error
                        (setq interval-list (interval-edit interval-list time-1 time-1 time-3)))))

(defregression (:time 6)
  "nested intervals in list"
  (let* ((interval-list nil)
         (time-1 (parse-timestring "2002-01-01 10:00:00"))
         (time-2 (parse-timestring "2002-01-01 11:00:00"))
         (time-3 (parse-timestring "2002-01-01 12:00:00"))
         (time-4 (parse-timestring "2002-01-01 13:00:00"))
         (time-5 (parse-timestring "2002-01-01 14:00:00"))
         (time-6 (parse-timestring "2002-01-01 15:00:00")))
    
    (setq interval-list (interval-push interval-list (make-interval :start time-1 :end time-6 :type :open)))
    (setq interval-list (interval-push interval-list (make-interval :start time-2 :end time-3 :type :closed)))
    (setq interval-list (interval-push interval-list (make-interval :start time-4 :end time-5 :type :closed)))
    (setq interval-list (interval-edit interval-list time-1 time-1 time-4))))

(defregression (:time 7)
    "Test the boundaries of Local Time with granularity of 1 year"
  (let ((sec-in-year (* 60 60 24 365))
        (year (time-element (make-time) :year)))
    (dotimes (n 50)
      (let ((date (make-time :second (* n sec-in-year))))
        (unless (= (+ year n)
                   (time-element date :year))
          (error (format nil "Local time loses its accuracy in ~S. It thinks it's ~S"
                         (+ year n) (time-element date :year))))))))

(defregression (:time 9)
  "Test db-timestring"
  (flet ((grab-year (dbstring)
           (parse-integer (subseq dbstring 1 5))))
    (let ((second-in-year (* 60 60 24 365)))
      (dotimes (n 2000)
        (let* ((second (* -1 n second-in-year))
               (date (make-time :year 2525 :second second)))
	  (cmsg "~D ~A" second date)
          (assert
                (= (grab-year (db-timestring date))
                   (time-element date :year))))))))

(defregression (:time 12)
  "Conversion between MJD and Gregorian"
  (let ((base 0))
    (while (< base 10000)
      (unless (= (apply #'gregorian-to-mjd (mjd-to-gregorian base)) base)
        (error "Base = ~s" base))
      (incf base 1))))
