(in-package :odcl)

(defregression (:queue 1)
  "Ensure binheap-delete-min preserves ordering."
  (let ((heap (make-instance 'binheap :test #'char-lessp))
	(list '(#\G #\C #\F #\A #\K #\J #\D #\E #\B #\H #\I)))
    (dolist (item list)
      (binheap-insert heap item))
    (do ((previous nil)
	 (item (binheap-delete-min heap) (binheap-delete-min heap)))
	((not item))
      (when previous
	(assert (char-lessp previous item)))
      (setq previous item))))

(defregression (:queue 2)
  "Ensure binheap-remove removes correct item."
  (let ((heap (make-instance 'binheap :test #'char-lessp))
	(list '(#\G #\C #\F #\A #\K #\J #\D #\E #\B #\H #\I)))
    (dolist (item list)
      (binheap-insert heap item))
    (binheap-remove heap #\C)
    (do ((item (binheap-delete-min heap) (binheap-delete-min heap)))
	((not item))
      (assert (not (char-equal #\C item)))
      (assert (member item list :test #'char-equal)))))

(defregression (:queue 3)
  "Ensure binheap-find-match returns correct item."
  (let ((heap (make-instance 'binheap :test #'char-lessp))
	(list '(#\G #\C #\F #\A #\K #\J #\D #\E #\B #\H #\I)))
    (dolist (item list)
      (binheap-insert heap item))
    (assert (eql #\C (binheap-find-match heap #\C)))))
