;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: cl-user -*-
;;; $Id: package.lisp,v 1.89 2003/05/27 16:43:16 ayres Exp $
;;;
;;; Copyright (c) 2000 - 2003 onShore Development, Inc.

(in-package :cl-user)

(eval-when (:compile-toplevel :load-toplevel :execute)

  (defpackage :odcl
    (:use :common-lisp)
    (:export
     ;; Strings
     #:ensure-string
     #:random-string
     #:string-truncate
     #:string-pretty-truncate
     #:first-char
     #:last-char
     #:filter-list
     #:split-string
     #:split
     #:split-counted
     #:string-join
     #:char-replace
     #:overlay
     #:char-count
     #:string-or-nil
     #:strcat

     #:escape-string
     #:collated-string<
   
     ;; FilesystemDB
     #:make-fsdb
     #:find-fsdb
     #:destroy-fsdb
     #:fsdb-add
     #:fsdb-get
     #:fsdb-del

     ;; Log
     #:write-syslog

     ;; Event
     #:event-listener-register
     #:event-listener-deregister
     #:publish-event
     #:event-listener
     #:notify
     #:simple-listener
     #:serve-event
     
     ;; Messages
     #:synchronizer
     #:notifier
     #:def-message-type
     #:message-types
     #:subscribe
     #:unsubscribe

     
     
     ;; transactable-store (protocol defined in transaction.lisp)
     #:transactable-store
     #:editing-context-bindings
     #:get-store-instance-by-key
     #:add-storage-class
     #:initialize-store
     #:oid
   
     ;; transaction-object (protocol defined in transaction.lisp)
     #:transaction-object
     #:instance-key
     #:instance-snapshot
     #:instance-restore
     #:transaction-objects-equal

     ;; Editing Context
     #:current-transaction
     #:editing-context
     #:*default-editing-context*
     #:*ec-unwinding*
     #:destroy-editing-context
     #:ec-on-txn-commit
     #:ec-on-txn-abort
     #:with-context
     #:without-context
     #:ec-begin
     #:ec-reset
     #:ec-insert
     #:ec-delete
     #:ec-propagate
     #:ec-edit
     #:ec-commit
     #:ec-abort
     #:ec-invalidate
     #:ec-scan
     #:instance-by-key
     #:ec-cache-get
     #:ec-cache

     ;; property sets
     #:get-object-meta
     #:get-class-index
     #:define-index
     #:index-clear
     #:index-type
     #:create-indexed-value

     ;; Index
     #:indexed-value
     #:index-set
     #:init-index
     #:index-name
     #:index-clear

     ;; Diagnostics
     #:*console-spam*
     #:*diagnostics*
     #:cmsg
     #:cmsg-add
     #:cmsg-c
     #:cmsg-remove

     ;; Filesystem
     #:ensure-directory
     #:files-under                      ; cmu
     #:destroy-directory
     #:temp-file
     #:copy-file
     #:extend-path
     #:write-to-file
     #:read-from-file

     ;; Assert
     #:assert-member
     #:assert-len
     #:assert-eql
     #:assert-equal

     #:*country*
     #:*lang*
     #:*propertied-objects*
     #:addtext
     #:array-to-string
     #:avl-tree
     #:break-list
     #:randomize-list
     #:c-add
     #:c-copy
     #:c-map
     #:c-remove
     #:c-subseq
     #:c-test
     #:cache-delete
     #:cache-flush
     #:cache-get
     #:cache-mark
     #:cache-put
     #:char-to-char-in-string
     #:class-search-form-spec
     #:def-export-format-spec
     #:def-psheet-specs
     #:def-result-spec
     #:def-search-spec
     #:add-terms-to-search-spec
     #:remove-terms-from-search-spec
     #:defproperties
     #:defregression
     #:destroy-cache
     #:expect-error
     #:replace-at-index
     #:insert-at-index
     #:delete-at-index
     #:delete-at-positions
     #:drill-car
     #:editable-properties-for-set
     #:ensure-integer
     #:ensure-keyword
     #:expand-directory
     #:export-format-spec-named
     #:fill-property-template
     #:filter-list2
     #:fixme
     #:flatten
     #:flatten-alist
     #:plist->alist
     #:plist-remove-if
     #:plist-rename
     #:plist-reformat
     #:alist->plist
     #:generate-result-set
     #:generate-result-set-for-class
     #:generate-search-form-set
     #:alistp
     #:get-alist
     #:get-plist
     #:memf
     #:get-property
     #:get-property-n
     #:get-utime
     #:gettext
     #:handler-case-if
     #:hashkeys
     #:hashvalues
     #:if-bind
     #:intersect-2
     #:ip-address-string
     #:key-partition
     #:keyword->symbol
     #:lce-insert
     #:lce-remove
     #:lce-seed
     #:lightly-tokenize
     #:listify
     #:loop-over-lines
     #:mailer-send
     #:make-cache
     #:make-keywords-into-list
     #:maybecar
     #:mlet
     #:msetq
     #:nonempty
     #:note-stat
     #:object-properties
     #:get-property-sheet-data
     #:get-property-sheet-spec
     #:operate-on-string
     #:padstring
     #:pairify
     #:parse-boolean
     #:parse-csv-string
     #:parse-currency
     #:parse-integer-insensitively
     #:partition-list
     #:partition-pairwise
     #:print-iterator
     #:print-list
     #:print-special-values
     #:properties-for-class
     #:push-end
     #:get-property-names-for-class
     #:property-metadata
     #:property-template-display
     #:property-template-null-value
     #:read-chunque
     #:read-comma-delimited
     #:read-comma-sep
     #:read-delimited
     #:read-int-with-default
     #:read-list-or-nil
     #:read-number-or-nil
     #:read-string-with-default
     #:regress
     #:replace-char
     #:result-set-default-fields
     #:result-set-spec-for-class
     #:round-to
     #:simple-cache-error
     #:simple-cache-mark-unsupported
     #:split-counted
     #:split-tok
     #:stat-integer-val
     #:store-properties
     #:store-property
     #:str-n-or-y
     #:str-y-or-n
     #:string-empty-p
     #:string-nil-or-empty-p
     #:string-replace
     #:string-replacing-char
     #:string-to-array
     #:stringify
     #:strip-character
     #:strip-characters
     #:symconcat
     #:update-alist
     #:uri-escape-string
     #:uri-unescape-string
     #:when-bind
     #:while
     #:while-not
     #:write-padded
     #:write-space
     #:y-or-n-string

     ;; Time

     #:bad-component
     #:current-day
     #:current-month
     #:current-year
     #:day-duration
     #:db-timestring
     #:decode-duration
     #:decode-time

     #:duration
     #:duration+
     #:duration<
     #:duration<=
     #:duration=
     #:duration>
     #:duration>=
     #:duration-day
     #:duration-hour
     #:duration-minute
     #:duration-month
     #:duration-second
     #:duration-year
     
     #:duration-reduce                  ;

     #:format-duration
     #:format-time

     #:get-time

     #:make-interval
     #:interval-clear
     #:interval-contained
     #:interval-data
     #:interval-edit
     #:interval-end
     #:interval-match
     #:interval-push
     #:interval-relation
     #:interval-start
     #:interval-type
     
     #:make-duration
     #:make-time
     #:merged-time
     #:midnight
     #:month-name
     #:parse-date-time
     #:parse-timestring
     #:print-date
     #:roll
     #:roll-to
     #:time
     #:time+
     #:time-
     #:time-by-adding-duration
     #:time-compare
     #:time-difference
     #:time-dow
     #:time-element
     #:time-max
     #:time-min
     #:time-mjd
     #:time-msec
     #:time-p
     #:time-sec
     #:time-well-formed
     #:time-ymd
     #:time<
     #:time<=
     #:time=
     #:time>
     #:time>=
     #:timezone
     #:universal-time
     #:unix-time
     #:wall-time
     #:wall-timestring
     #:week-containing
     
     ))

  (pushnew :odcl *features*)
  )                                     ; eval-when
