
#include <stdio.h>

#define OL 218
#define OR 191
#define H 196 
#define UL 192
#define UR 217
#define OM 194
#define UM 193
#define LM 195
#define RM 180
#define V 179
#define MM 197

#define dOL 201
#define dOR 187
#define dH 205
#define dUL 200
#define dUR 188
#define dOM 203
#define dUM 202
#define dLM 204
#define dRM 185
#define dV 186
#define dMM 206

#define ShLi 176   /* IBM Shade Light */
#define ShMe 177   /* IBM Shade Medium */
#define ShBo 178   /* IBM Shade Bold */
#define BlG 219    /* IBM "Block ganz" */
#define BlU 220    /* IBM "Block unten" */
#define BlO 223    /* IBM "Block oben" */
#define BlL 177    /* IBM "Block links" */
#define BlR 177    /* IBM "Block rechts" */
 
#define _SW 0  /* Background Colors */
#define _BL 1*16
#define _GN 2*16
#define _CY 3*16
#define _RT 4*16
#define _MG 5*16
#define _BR 6*16
#define _lGR 7*16

#define SW 0  /* Foreground Colors 0-7 */
#define BL 1
#define GN 2
#define CY 3
#define RT 4
#define MG 5
#define BR 6
#define lGR 7

#define dGR 8  /* Foreground Colors 8-15 */
#define lBL 9
#define lGN 10
#define lCY 11
#define lRT 12
#define lMG 13
#define GE 14
#define WS 15

#define BLINK 1*128   /* BLINK-Bit, Bit 7 in Colorword */

struct SCR {
        unsigned int Z;         /* aktuelle Zeile */
        unsigned int Sta;       /* Startspalte */
        unsigned int Stp;       /* Stopspalte => neue Startspalte */
        unsigned char Symbol;   /* ASCII-Charakter */
        unsigned char Color;    /* Vorder- und Hintergrundfarbe */
        unsigned int Marke;     /* letzte Spalten-Schreibposition */
};

unsigned char screen[25][160];

void fillup(struct SCR *);

void filltext(struct SCR *, char *);

#define German  1
#define English 2
#define Finnish 3

void main(void)
{
        unsigned int count, i, j , k, mark;
        unsigned char zei, col;

#if !defined(LANGUAGE) || (LANGUAGE==German)
        char Title1[]="Choose-OS, Version 0.8; Graphik by T. Schmid";
        char Menu1[]=" Vorhandene Betriebsysteme ";
        char Logo[]="*!* Powered by Linux *!*";
#else
 #if LANGUAGE == English
        char Title1[]="Choose-OS, Version 0.8; Graphics by T. Schmid";
        char Menu1[]=" Choose an Operating System ";
        char Logo[]="*!* Powered by Linux *!*";
 #else
  #if LANGUAGE == Finnish
        char Title1[]="Choose-OS, versio 0.8; Grafiikka: T. Schmid";
	// \204 = '' and \224 = '' (cp437)
        char Menu1[]=" Valitse k\204ytt\224j\204rjestelm\204 ";
        char Logo[]="*!* Voimaa Linuxista *!*";
  #else
	#error "Invalid language name"
  #endif
 #endif
#endif
        struct SCR scr1, *pscr1;

        pscr1 = &scr1;


/* Initialization  of screen array */
for (i=0; i<25 ; i++)
{
   for (j=0; j<80; j++)
   {
      screen[i][2*j] = BlG;
      screen[i][(2*j)+1] = _SW + lGR;
   };
};

/* 2. Zeile */
        pscr1->Z = 1;
        pscr1->Sta = 2;
        pscr1->Stp = 3;
        pscr1->Symbol = dOL;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 1;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 77;
        pscr1->Symbol = dH;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 1;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 78;
        pscr1->Symbol = dOR;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* Zeile 3 */
        pscr1->Z = 2;
        pscr1->Sta = 2;
        pscr1->Stp = 3;
        pscr1->Symbol = dV;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 2;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 4;
        pscr1->Symbol = ' ';
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 2;
        pscr1->Sta = pscr1->Marke;
        pscr1->Color = _CY+BL;
        filltext(pscr1, Title1);
        pscr1->Marke = pscr1->Stp;
        
        pscr1->Z = 2;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 52;
        pscr1->Symbol = ' ';
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 2;
        pscr1->Sta = pscr1->Marke;
        pscr1->Color = BLINK+_CY+WS;
        filltext(pscr1, Logo);
        pscr1->Marke = pscr1->Stp;
        
        pscr1->Z = 2;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 77;
        pscr1->Symbol = ' ';
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 2;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 78;
        pscr1->Symbol = dV;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 4. Zeile  */
        pscr1->Z = 3;
        pscr1->Sta = 2;
        pscr1->Stp = 3;
        pscr1->Symbol = dUL;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 3;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 77;
        pscr1->Symbol = dH;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 3;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 78;
        pscr1->Symbol = dUR;
        pscr1->Color = _CY+RT;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 3;
        pscr1->Sta = 55;
        pscr1->Stp = 57;
        pscr1->Symbol = BlU;
        pscr1->Color = _CY+SW;   
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 3;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 59;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 3;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 61;
        pscr1->Symbol = BlU;
        pscr1->Color = _CY+SW;  
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 5. Zeile  */
        pscr1->Z = 4;
        pscr1->Sta = 3;
        pscr1->Stp = 77;
        pscr1->Symbol = ShLi;
        pscr1->Color = _lGR+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 4;
        pscr1->Sta = 54;
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 4;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 6. Zeile  */
        pscr1->Z = 5;
        pscr1->Sta = 53;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 5;
        pscr1->Sta = 54;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 7. Zeile  */
        pscr1->Z = 6;
        pscr1->Sta = 53;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 6;
        pscr1->Sta = 54;
        pscr1->Stp = 55;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 6;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 56;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 6;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 57;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 6;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 58;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 6;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 59;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 6;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 60;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 6;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 61;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 6;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 8. Zeile  */
        pscr1->Z = 7;
        pscr1->Sta = 53;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 56;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 57;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 58;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 59;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 60;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 61;
        pscr1->Symbol = BlU;
        pscr1->Color = _BR+GE; 
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 7;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 9. Zeile  */
        pscr1->Z = 8;
        pscr1->Sta = 53;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 8;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 8;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 59;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 8;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 60;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+lGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 8;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 61;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 8;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 8;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 8;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 64;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 10. Zeile */
        pscr1->Z = 9;
        pscr1->Sta = 3;
        pscr1->Stp = 4;
        pscr1->Symbol = OL;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 5;
        pscr1->Symbol = H;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 6;
        pscr1->Symbol = RM;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Color = _CY+BR;
        filltext(pscr1, Menu1);
        pscr1->Marke = pscr1->Stp;
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = pscr1->Marke + 1;
        pscr1->Symbol = LM;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 44;
        pscr1->Symbol = H;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 45;
        pscr1->Symbol = RM;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 49;
        pscr1->Symbol = ' ';
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 50;
        pscr1->Symbol = LM;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 51;
        pscr1->Symbol = OR;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 9;
        pscr1->Sta = 53;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlO;
        pscr1->Color = _SW+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 60;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 61;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 9;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 65;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 11.-16.Zeile */
    for (i=10; i<16; i++)
    {
        pscr1->Z = i;
        pscr1->Sta = 3;
        pscr1->Stp = 4;
        pscr1->Symbol = V;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = i;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 50;
        pscr1->Symbol = ' ';
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = i;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 51;
        pscr1->Symbol = V;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
    }

/* 11. Zeile again... */
        pscr1->Z = 10;
        pscr1->Sta = 52;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 56;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 58;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 58;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 60;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 65;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 10;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 66;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 12. Zeile again... */
        pscr1->Z = 11;
        pscr1->Sta = 51;
        pscr1->Stp = 52;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 11;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 53;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 11;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 54;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 11;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 61;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 11;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 11;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 11;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 67;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 13. Zeile */
        pscr1->Z = 12;
        pscr1->Sta = 50;
        pscr1->Stp = 51;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 12;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 52;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 12;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 53;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 12;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 54;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 12;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 12;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlU;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 12;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 64;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 12;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 68;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 14. Zeile again... */
        pscr1->Z = 13;
        pscr1->Sta = 49;
        pscr1->Stp = 52;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 13;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 64;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 13;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 65;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 13;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 68;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 13;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 69;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
/* 15. Zeile again... */
        pscr1->Z = 14;
        pscr1->Sta = 49;
        pscr1->Stp = 51;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 14;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 14;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 56;
        pscr1->Symbol = BlR;
        pscr1->Color = _lGR+lGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 14;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 64;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 14;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 65;
        pscr1->Symbol = BlO;
        pscr1->Color = _SW+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 14;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 69;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
/* 16. Zeile again... */
        pscr1->Z = 15;
        pscr1->Sta = 48;
        pscr1->Stp = 49;
        pscr1->Symbol = BlU;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 51;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 52;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 53;
        pscr1->Symbol = BlO;
        pscr1->Color = _SW+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 56;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+lGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 64;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 67;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 15;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 68;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 17. Zeile */
        pscr1->Z = 16;
        pscr1->Sta = 3;
        pscr1->Stp = 4;
        pscr1->Symbol = UL;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 50;
        pscr1->Symbol = H;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
        
        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 51;
        pscr1->Symbol = UR;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = 46;
        pscr1->Stp = 47;
        pscr1->Symbol = BlU;
        pscr1->Color = _CY+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 52;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 53;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlO;
        pscr1->Color = _SW+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 64;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 65;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 67;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 68;
        pscr1->Symbol = BlU;
        pscr1->Color = _SW+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 16;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 69;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 18. Zeile */
        pscr1->Z = 17;
        pscr1->Sta = 4;
        pscr1->Stp = 45;
        pscr1->Symbol = ShLi;
        pscr1->Color = _lGR+dGR;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 17;
        pscr1->Sta = 45;
        pscr1->Stp = 46;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 17;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 53;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 17;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 17;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 17;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 17;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 70;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 19. Zeile */
        pscr1->Z = 18;
        pscr1->Sta = 45;
        pscr1->Stp = 46;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 18;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 18;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 18;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 60;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 18;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 61;
        pscr1->Symbol = BlO;
        pscr1->Color = _SW+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 18;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 18;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 18;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 71;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 20. Zeile */
        pscr1->Z = 19;
        pscr1->Sta = 45;
        pscr1->Stp = 46;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 19;
        pscr1->Sta = pscr1->Marke; 
        pscr1->Stp = 55;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 19;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 62;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+SW;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 19;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 63;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 19;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 68;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 19;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 70;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 21. Zeile */
        pscr1->Z = 20;
        pscr1->Sta = 48;
        pscr1->Stp = 51;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 20;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 54;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 20;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 55;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 20;
        pscr1->Sta = 63;
        pscr1->Stp = 66;
        pscr1->Symbol = BlG;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

        pscr1->Z = 20;
        pscr1->Sta = pscr1->Marke;
        pscr1->Stp = 67;
        pscr1->Symbol = BlO;
        pscr1->Color = _lGR+GE;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);

/* 22. Zeile - 23. Zeile */
        /* so wie initialisiert */

/* 24.-25. Zeile */
    for (i=23; i<25; i++)
    {
        pscr1->Z = i;
        pscr1->Sta = 0;
        pscr1->Stp = 80;
        pscr1->Symbol = ' ';
        pscr1->Color = _lGR+WS;
        pscr1->Marke = pscr1->Stp;
        fillup(pscr1);
    }

        
/* Ausgabe auf Stdout */
        for (i=0; i<25 ; i++)
        {
            for (j=0; j<80; j++)
            {
                printf("%c%c",screen[i][2*j], screen[i][(2*j)+1]);
            };
        };
}

void fillup(struct SCR *pscr)
{
    int i;
   
    for(i = (pscr->Sta); i < (pscr->Stp); i++)
    {
        screen[pscr->Z][2*i] = pscr->Symbol;
        screen[pscr->Z][(2*i)+1] = pscr->Color;
    }
}

void filltext(struct SCR *pscr, char *pstring)
{
    int i, m;
 
        for (i=0; pstring[i] != '\0' ; i++)
        {
            screen[pscr->Z][((pscr->Sta)+i)*2] = pstring[i];
            screen[pscr->Z][((pscr->Sta)+i)*2 +1] = pscr->Color;
            m = (pscr->Sta)+(i+1);
/*
          printf("Sym: %c, ", screen[pscr->Z][(pscr->Sta)+(2*i)]);
          printf("Pos: %d, ", m);
*/
        }
        pscr->Stp = m;
 /*         printf("EndPos: %d, ", pscr->Stp);   */
}
