#
# 	Analyse d'entete de fichiers AIFF
# 	(c) 1997 Alexandre Burton
# 	v1.80a (10/08/97)
#

proc GetByte { fid } {
    set byte [read $fid 1]
    if {[string length $byte] == 1} {
    	if { $byte != "" } {
			scan $byte "%c" val
			return $val
		} else { return 0 }
	} else { if [eof $fid] {return -1} else {return 0} }
}

proc ieee80toSR {ieee80} {
	switch -- [format %.0f [expr  $ieee80 / 1.0e+18]] {
		302503	{puts ***trapped\ 48000}
		302502	{puts ***trapped\ 44100}
		302434	{return 32000}
		302433	{puts ***trapped\ 32000}
		302428	{puts ***trapped\ 22050}
		302471	{puts ***trapped\ 16000}
		302465	{puts ***trapped\ 11025}
		302453	{puts ***trapped\   8000}
	}

    if {$ieee80 == 3.02503e+23} {return 48000}
    if {$ieee80 == 3.0250212236716217e+23} {return 44100}  
	if {$ieee80 == 3.025018341e+23} {return 44100}
    if {$ieee80 == 3.02502e+23} {return 44100}    
    if {$ieee80 == 3.025021223e+23} {return 44100}    
	if {$ieee80 == 3.02501834137e+23} {return 44100} 
    if {$ieee80 == 3.02434e+23} {return 32000}    
    if {$ieee80 == 3.0243393674290388e+23} {return 32000}
    if {$ieee80 == 3.02428e+23} {return 22050}    
    if {$ieee80 == 3.02471e+23} {return 16000}    
    if {$ieee80 == 3.02465e+23} {return 11025}    
    if {$ieee80 == 3.02453e+23} {return 8000} 
    puts "erreur, ieee80 ($ieee80) inconnu"
    return 0
}

proc joinBytes {file from to mode} {
    if { $from < $to } { set step 1 } { set step -1 }
    switch $mode {
		text {
		    set r ""
		    for { set i $from } { $i <= $to } { incr i $step } {
			append r [format %c [GetByte $file]] } } 	
		value {
		    set r 0
		    for { set i $from } { $i >= $to } { incr i $step } {
			set m [expr pow(256,$i)]
			set r [expr $r+([GetByte $file]*$m)] } } 	
		default {
		    puts "error: unknown joinBytes mode"
		    return 0 } }
    return $r 
}


proc aiffread {path} {

    set f [open $path r]
    set form [joinBytes $f 0 3 text]

	if {$form == "RIFF"} {wavread $f; return}

    if {$form != "FORM"} {
		puts "erreur: ne semble pas etre un fichier AIFF"
		return 0 }

    set size   [expr int([joinBytes $f 3 0 value])]
    set format [string tolower [joinBytes $f 0 3 text]]
	set chunk  [joinBytes $f 0 3 text]
    set csize  [joinBytes $f 3 0 value]
    set chans  [expr int([joinBytes $f 1 0 value])]
    set frames [expr int([joinBytes $f 3 0 value])]
    set bits   [expr int([joinBytes $f 1 0 value])]
    set ieee80 [joinBytes $f 9 0 value]

puts "$size $format $chunk $csize $chans $frames $bits"
    if ![set rate [ieee80toSR $ieee80]] {
	return 0 }

    set duree [format %.4f [expr 1.0 * $frames / $rate]]
#    set next [joinBytes $f 0 3 text]

#    if {$next != "MARK"} {
#	puts "erreur: probleme de chunks, sans doute AIFC"
#	return 0 }
    
    close $f
    return [concat $duree $rate $format $chans $bits]
}


proc wavread {path} {
set f $path
puts "looks like a RIFF"
    set size   [joinBytes $f 3 0 value]
    set format [joinBytes $f 3 0 text]
    set fmt  [joinBytes $f 0 3 text]
    set fmtsize  [expr int([joinBytes $f 0 3 value])]
    set fmtag  [expr int([joinBytes $f 0 1 value])]
    set chans [expr int([joinBytes $f 0 1 value])]
    set sr [expr int([joinBytes $f 0 3 value])]
    set frames [joinBytes $f 0 3 value]
    set byts   [expr int([joinBytes $f 0 3 value])]
    set bits   [expr int([joinBytes $f 0 1 value])]
    set bchan   [expr int([joinBytes $f 0 1 value])]
    set dat   [expr int([joinBytes $f 0 1 value])]
    set len   [expr int([joinBytes $f 0 3 value])]
#    set ieee80 [joinBytes $f 9 0 value]


puts "length 1: $size \n
format: $format \n
fm: $fmt \n
fmlength: $fmtsize \n
tag: $fmtag \n
chan: $chans \n
sampling rtae: $sr \n
\n
$byts $bits $bchan\n \
	$dat $len"
return
}

#    4 bytes  'RIFF'
#    4 bytes  <length>
#    4 bytes  'WAVE'
#    4 bytes  'fmt '
#    4 bytes  <length>       ; 0x10 - length of 'fmt ' block
#    2 bytes  01             ; format tag
#    2 bytes  01             ; channels (1=mono, 2=stereo)
#    4 bytes  xxxx           ; samples per second
#    4 bytes  xxxx           ; bytes per second
#    2 bytes  01             ; bytes per sample
#    2 bytes  08             ; bits per channel
#    4 bytes  'data'
#    4 bytes  <length>
#      bytes  <sample data>

## pour l'utilisation en command-line UNIX
#if [llength $argv] {puts [aiffread $argv]}
