#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  IMPORTADDRESS2 screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "<!-- Beginning of screen_IMPORTADDRESS2 -->\n";
  CSESSION->screen = "importaddress2";	// Admin screen name

  contents = CAMAS.Parse.parse_html(contents,
                        ([
                            "camas_submit_uploadimport": tag_camas_submit_uploadimport
                         ]),
                        ([
                           "camas_loop_fields": container_camas_loop_fields,
                         ]),
                        id);
  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->name = "camasimportaddressform";

  args = CAMAS.Tools.set_target(id, args);
 
  out += CAMAS.Tools.make_container("form", args, contents);

  out += "<!-- End of screen_IMPORTADDRESS2 -->";
  return out;
}

string tag_camas_submit_uploadimport(string tag_name, mapping args, object id)
{
  return CAMAS.Tools.formdrawbutton(id,"m_uploadandimport", "actionimportaddress2", MSG(M_IMPORTADDRESSBOOK)+"...");
}

//! container : camas_loop_fields 
//!  A loop on the fields to import.
//! variable: #user_field#
//!  The user field to import from
//! variable: #column_number#
//!  The column number (usefull when we deal with CSV)
//! subcontainer: select_camas_fields
//! note: screen: importaddress2
string container_camas_loop_fields(string tag_name, mapping args, string contents, object id)
{
  string out = "<!-- Beginning of camas_loop_fields -->\n";
  array(string) user_fields = ({ });
  int column_number = 0;
  foreach(CSESSION->imported_addrbook, array column)
  {
    user_fields += ({ column[0] });
  }
  string originalcontents = contents;                           // Backup the original contents for parsing it several times
  mapping select_args;
  string select_contents;
  string rands = "thisisarandomstring3294832094832904832RJKZEJRKZKjfn43249832U432";
  string parsed_contents = CAMAS.Parse.parse_html(originalcontents,
      ([ ]),
      ([
        "select_camas_fields": lambda(string name, mapping _select_args, string _select_contents)
                                { 
                                  select_args = _select_args;
                                  select_contents = _select_contents;
                                  return rands;
                                }
       ]));
  
  foreach(user_fields, string user_field)
  {
    if(!sizeof(user_field))
      user_field = "?";
    array outlet = ({
        ([
           "user_field": user_field,
           "column_number": ++column_number
        ])
      });
    
    contents = replace(parsed_contents, rands,
            container_select_camas_fields("select_camas_fields", select_args,
              select_contents, id, user_field, column_number));
    out += do_output_tag(args, outlet, contents, id);
  }
  out += "<!-- End of camas_loop_fields -->\n";
  return out;
}

//! container: select_camas_fields
//!  A select box for the destination field when importing an addressbook
//! parentcontainer: camas_loop_fields
string container_select_camas_fields(string tag_name, mapping args, string contents, object id, string user_field, int column_number)
{
  object addressbook = CAMAS.AddressBook2.get_currentaddrbook(id);
  string out = "<!-- Beginning of select_camas_field -->\n";
  string options = "";
  string lower_user_field = lower_case(user_field);
  int already_selected = 0;
  foreach(sort(addressbook->get_all_attributes()), int attribute)
  {
    string translated_attribute;
    mapping largs = ([ "value": attribute ]);
    if(internal_attributenames2translated[attribute])
      translated_attribute = MSG(internal_attributenames2translated[attribute]);
    else
      translated_attribute = "*** MISSING MESSAGE ***";
    if(lower_case(translated_attribute) == lower_user_field)
    {
      largs->selected = "1";
      already_selected = 1;
    }
    string option_content = translated_attribute;
    options += CAMAS.Tools.make_container("option", largs, option_content);
  }
  mapping largs = ([ ]);
  if(!already_selected)
    largs->selected = 1;
  options = CAMAS.Tools.make_container("option", largs, MSG(M_SELECT)+"...") 
     + options;
  args->name = "select_" + (string)column_number;
  out = CAMAS.Tools.make_container("select",args,options);
  out += "<!-- End of select_camas_fields -->\n";
  return out; 
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
