#ifndef _FUNCTIONS_C_
#define _FUNCTIONS_C_

#include <string.h>
#include <stdlib.h>


// The return values of these functions have to be NEW, for the "pList * list"
// is going to be deleted !!!

pElement * _plus(pList * list) {
  pElement * retv = 0;
  double sum = 0;
  bool doub=false;
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    i = i->Eval(list);
    if (i) {
      if (i->isInt()) {
	sum += ((pInt*)i)->getInt();
      } else {
	if (i->isDouble()) { doub = true; sum += ((pDouble*)i)->getDouble(); }
      }
    }
  }
  if (doub==true)
    retv = new pDouble(sum);
  else
    retv = new pInt(int(sum));
  return retv;
}

pElement * _minus(pList * list) {
  pElement * retv = 0;
  double sum = 0;
  bool doub=false;
  double buf = 0;
  bool test = false;
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    i = i->Eval(list);
    if (i) {
      if (i->isInt()) buf = ((pInt*)i)->getInt();
      else if (i->isDouble()) { doub = true; buf = ((pDouble*)i)->getDouble(); }
      if (!test) { sum += buf; test = true; }
      else sum -= buf;
    }
  }
  if (doub==true)
    retv = new pDouble(sum);
  else
    retv = new pInt(int(sum));
  return retv;
}

pElement * _times(pList * list) {
  pElement * retv = 0;
  double prod = 1.0;
  bool doub=false;
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    i = i->Eval(list);
    if (i) {
      if (i->isInt()) prod *= ((pInt*)i)->getInt();
      else if (i->isDouble()) { doub = true; prod *= ((pDouble*)i)->getDouble(); }
    }
  }
  if (doub==true)
    retv = new pDouble(prod);
  else
    retv = new pInt(int(prod));
  return retv;
}


pElement * _eval(pList * list) {
  pElement * retv = 0;
  pElement * i=list->Top()->Next();
  if (i->Next()==0) {
    i = i->Eval(list);
    if (i) i = i->Eval(list);
  }
  else
    cout << "*** too many arguments for eval" << endl;
  if (i) retv = i->copy();
  return retv;
}


pElement * _setq(pList * list) {
  pElement * retv = 0;
  pElement * var = list->Top()->Next();
  // var = var->Eval(list); // bei set!!!
  if (var) {
    if (var->isString()) {
      pElement * value = var->Next();
      if (value) { // set var to value
	// cout << "setq: " << var->get() << value->get() << endl;
	// value = value->Eval(list);
	// cout << "val: " << value << ", " << value->quoted() << ", " << value->isList() << endl;
	if ((value->isList() && (value->quoted()==0))||(value->isString())) value = value->Eval(list);
	if (!value->isError()) {
	  ElPtr * el = new ElPtr(value->copy(),var->get());
	  addToElList(el);
	  retv = value->copy();
	} else {
	  retv = Error->copy(); // error is already copied!
	}
      } else { // evaluate var
	//retv = value->copy();
      }
    } else cout << "*** setq needs string as a variable name" << endl;
  } else cout << "*** setq needs parameters" << endl;
  if (retv==0) retv = new pList();
  return retv;
}


pElement * _set(pList * list) {
  pElement * retv = 0;
  pElement * var = list->Top()->Next();
  if (var) {
    // cout << "set: " << var->get() << endl;
    var = var->Eval(list); // jawoll!
    if (var) {
      pElement * value = var->Next();
      if (value) { // set var to value
	// value = value->Eval(list);
	ElPtr * el = new ElPtr(value->copy(),var->get());
	addToElList(el);
	retv = value->copy();
      } else { // evaluate var
	//retv = value->copy();
      }
    } else cout << "*** set needs parameters" << endl;
  }
  return retv;
}



pElement * _oblist(pList * list) {
  pElement * retv = new pList();
  for (ElPtr * i=UserElementNames;i!=0;i=i->Next()) {
    //cout << i->Name() << " - " << i->Element()->elementName() << endl;
    ((pList*)retv)->appendElement(new pString(i->Name()));
  }
  return retv;
}



pElement * _funlist(pList * list) {
  pElement * retv = new pList();
  for (int i=0;FunctionNames[i]!=0;i++) {
    ((pList*)retv)->appendElement(new pString(FunctionNames[i]));
  }
  return retv;
}



pElement * _car(pList * list) {
  pElement * retv = 0;
  pElement * i = list->Top()->Next(); // like: (car i)
  i = i->Eval(list);
  if (i) {
    if (!i->isList()) cout << "*** car needs a list as a parameter" << endl;
    else i = ((pList*)i)->Top();
  }
  retv = i->copy(); //->Eval();
  return retv;
}


pElement * _cdr(pList * list) {
  pElement * retv = 0;
  pElement * l = list->Top()->Next(); // like (cdr l),       exapmle: (cdr (cdr '(1 2 3))
  l = l->Eval(list);                  // (applied recursivly) is now: (cdr (2 3))
  if (l) {
    if (!l->isList()) cout << "*** cdr needs a list as a parameter" << endl;
    else {
      retv = new pList();
      l = ((pList*)l)->Top();
      if (l)
	for (pElement * i=l->Next();i!=0;i=i->Next())
	  ((pList*)retv)->appendElement(i->copy());
    }
  }
  return retv;
}

pElement * _nth(pList * list) {
  pElement * retv = 0;
  pElement * n = list->Top()->Next(); // like: (nth n i)
  n = n->Eval(list);
  if (n && n->isInt()) {
    pElement * i = n->Next();
    i = i->Eval(list);
    if (i) {
      if (!i->isList()) cout << "*** nth needs a list as a parameter" << endl;
      else {
	int nn = ((pInt*)n)->getInt();
	i = ((pList*)i)->Top();
	for (int ii=0;ii<nn;ii++) {
	  if (i) i = i->Next();
	}
      }
    }
    if (i) retv = i->copy(); //->Eval();
  } else cout << "*** usage: (nth n list)" << endl;
  if (retv==0) retv = new pList();  
  return retv;
}


pElement * _replacenth(pList * list) {
  pElement * retv = 0;
  pElement * n = list->Top()->Next(); // like: (replacenth n i r)
  n = n->Eval(list);
  if (n && n->isInt()) {
    pElement * i = n->Next();
    i = i->Eval(list);
    pList * rlist = (pList*) i;
    pElement * r = i->Next();
    r = r->Eval(list);
    if (i) {
      if (!i->isList()) cout << "*** usage (replacenth n list r)" << endl;
      else {
	int nn = ((pInt*)n)->getInt();
	i = ((pList*)i)->Top();
	for (int ii=0;ii<nn;ii++) {
	  if (i) i = i->Next();
	}
      }
    }
    // cout << "r: " << r->get() << ", rlist: " << rlist->get() << endl;
    bool ok = rlist->exchange(i,r->copy());
    retv = rlist->copy();
  } else cout << "*** usage: (replacenth n list r)" << endl;
  if (retv==0) retv = new pList();  
  return retv;
}

pElement * _append(pList * list) {
  pElement * retv = 0;
  pElement * a = list->Top()->Next(); // (append a li)
  a = a->Eval(list);
  if (a) {
    pElement * li = a->Next();
    li = li->Eval(list);
    if (!li->isList()) cout << "*** usage (append a list)" << endl;
    else {
      BOOL b = ((pList*)li)->appendElement(a->copy());
      // cout << b << endl;
      retv = li->copy();
    }
  }
  if (retv==0) retv = new pList();  
  return retv;
}

pElement * _length(pList * list) {
  pElement * retv = 0;
  pElement * li = list->Top()->Next(); // (length li)
  li = li->Eval(list);
  if (li && li->isList()) {
    retv = new pInt(((pList*)li)->length());
  } else cout << "*** usage: (length list)" << endl;
  if (retv==0) retv = new pList();  
  return retv;
}


pElement * _remove(pList * list) {
  pElement * retv = 0;
 
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    if (i->isString()) {
      for (ElPtr * e=UserElementNames;e!=0;) {
	if (strcmp(e->Name(),i->get())==0) {
	  removeFromElList(e);
	  e = 0;
	} else e=e->Next();
      }
    }
  }
  return new pList();
}
/*
pElement * _delete(pList * list) {
  pElement * retv = 0;
 
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    if (i->isString()) {
      for (ElPtr * e=UserElementNames;e!=0;) {
	if (strcmp(e->Name(),i->get())==0) {
	  if (e->Element()->isObject()) ((pObject*)e->Element())->deleteRadical();
	  else if (e->Element()->isValence()) ((pValence*)e->Element())->deleteValence();
	  // removeFromElList(e); this is done in radicals and valences destructors now!
	  e = 0;
	} else e=e->Next();
      }
    }
  }
  return new pList();
}
*/
pElement * _erase(pList * list) {
  return _remove(list);
  /*
  pElement * retv = 0;
 
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    if (i->isString()) {
      for (ElPtr * e=UserElementNames;e!=0;) {
	if (strcmp(e->Name(),i->get())==0) {
	  eraseFromElList(e);
	  e = 0;
	} else e=e->Next();
      }
    }
  }
  return new pList();*/
}


char * correct(char * in) {
  // cout << "IN [ " << in << " ]\n";
  char * out = 0;
  if (in!=0) {
    char cur;
    char prev;
    int len = strlen(in);
    int outpos = 0;
    out = new char[len];
    for (int i=0;i<len;i++) {
      cur = in[i];
      if (i>0) {
	if ((out[outpos-1]==' ')&&(cur==' ')) {
	} else {
	  if ((out[outpos-1]==' ')&&(cur==')')) { outpos--; }
	  out[outpos++] = cur;
	}
      } else { out[outpos++] = cur; }
      prev = cur;
    }
    out[outpos++] = 0;
    delete in;
  }
  // cout << "OUT [ " << out << " ]\n";
  return out;
}

pElement * _load(pList * list) {
  pElement * retv = 0;
  pElement * param = list->Top()->Next();
  if (param && param->isString()) {
    ifstream in(param->get());
    if (in!=0) {
      char * command = 0;
      char * swap = 0;
      char * buffer = new char[101];
      int bcount = 0;
      int paren = 0;
      char c;
      while(!in.eof()) {
	in.get(c);
	// cout << paren << " " << c << endl;
	if (c=='#') { while (c!='\n') in.get(c); }
	if ((paren>0)&&(c=='\n')) { while (c=='\n') in.get(c); }
	buffer[bcount++] = c;
	if (bcount==100) {
	  // cout << "<*>";
	  bcount = 0;
	  int swaplen = 0;
	  swap = command;
	  buffer[100] = '\0';
	  if (swap!=0) swaplen = strlen(swap);
	  command = new char[swaplen+102];
	  if (swap==0) sprintf(command,"%s",buffer);
	  else         sprintf(command,"%s%s",swap,buffer);
	  delete[] swap;
	  swap = 0;
	}
	if (c=='(') paren++;
	if (c==')') paren--;
	if (c=='\n') {
	  bcount--;
	  if (paren==0) {
	    if (bcount>0) {
	      buffer[bcount++] = '\0';
	      int swaplen = 0;
	      swap = command;
	      if (swap!=0) swaplen = strlen(swap);
	      command = new char[swaplen+bcount];
	      if (swap==0) sprintf(command,"%s",buffer);
	      else         sprintf(command,"%s%s",swap,buffer);
	      delete[] swap;
	      command = correct(command);
	      // cout << command << ";" << endl;
	      pElement * el = PARSE(command);
	      // if (el) cout << el->get() << endl;
	      if (el) el = el->Eval(); // caution: war vorher ohne list!! JW 2.8.99
	      // if (el) cout << el->get() << endl;
	      if (el) delete el;
	      delete[] command;
	      command = 0;
	      swap = 0;
	    }
	    bcount = 0;
	  }
	}
      }
      delete[] buffer;
    } else cout << "*** file does not exist!" << endl;
  } else cout << "*** specify a filename" << endl;

  if (retv==0) retv = _oblist(list);
  return retv;

}

pElement * _dump(pList * list) {
  pElement * retv = 0;
  for (ElPtr * i=UserElementNames;i!=0;i=i->Next()) {
    // if (i->Element()->isObject()) {
      //SyclRadical * r = (SyclRadical*) ((pObject*)i->Element())->getValue();
      // cout << *r << endl;
    //  }
  }
  if (retv==0) retv = new pList();
  return retv;
}



pElement * _for(pList * list) {
  pElement * retv = 0;
  pElement * el = list->Top()->Next();
  if (el && el->isList()) {
    pList * parameter = (pList*) el;
    if (parameter->Top() && parameter->Top()->isString()) {
      pString * name = (pString*) parameter->Top();
      pList * pCopy = (pList*) parameter->copy();
      pElement * sEl = pCopy->Top()->Next();
      sEl = sEl->Eval(pCopy);
      sEl = sEl->copy();
      delete pCopy;
      if (sEl && sEl->isInt()) {
	pInt * start = (pInt*) sEl;
	pList * pCopy = (pList*) parameter->copy();
	pElement * eEl = pCopy->Top()->Next()->Next();
	eEl = eEl->Eval(pCopy);
	eEl = eEl->copy();
	delete pCopy;
	if (eEl && eEl->isInt()) {
	  pInt * end = (pInt*) eEl;
	  if (parameter->Next() && parameter->Next()->isList()) {
	    pList * prgList = (pList*) parameter->Next();
	    int iStart = start->getInt();
	    int iEnd = end->getInt();
	    ElPtr * NamePtr = new ElPtr(start->copy(),name->get());
	    addToElList(NamePtr);
	    // loop starts here
	    for (int loop=iStart;loop<=iEnd;loop++) {
	      ((pInt*)NamePtr->Element())->setInt(loop);
	      pList * prgListVar = (pList*)prgList->copy();
	      //cout << ":: " << prgList->dumpit() << endl;
	      //cout << "c: " << prgListVar->dumpit() << endl;
	      for (pElement * i=prgListVar->Top();i!=0;i=i->Next()) {
		i = i->Eval(prgListVar);
	      }
	      delete prgListVar; prgListVar = 0;
	    }
	    // -----
	    removeFromElList(NamePtr); NamePtr = 0;
	  } else cout << "*** second parameter has to be a list of commands" << endl;
	} else cout << "*** last element of parameter list has to be an integer" << endl;
      } else cout << "*** second element of parameter list has to be an integer" << endl;
    } else cout << "*** first element of parameter list has to be a string" << endl;
  } else cout << "*** first parameter has to be a list, like (n 1 10)" << endl;
  if (retv==0) retv = new pList();
  return retv;
}


pElement * _list(pList * list) {
  pList * retv = new pList();
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    i = i->Eval(list);
    retv->appendElement(i->copy());
  }
  return retv;
}


pElement * _equal(pList * list) {
  pElement * retv = 0;
  pElement * i=list->Top()->Next();
  if (i && i->Next()) {
    pElement * k = i->Next();
    i = i->Eval(list);
    k = k->Eval(list);
    if (i->isA()==k->isA())
      if (i->compare(k)==0) retv = new pInt(1);
  } else cout << "comparison needs two arguments" << endl;
  if (retv==0) retv = new pList();
  return retv;
}


pElement * _notequal(pList * list) {
  pElement * retv = 0;
  pElement * i=list->Top()->Next();
  if (i && i->Next()) {
    pElement * k = i->Next();
    i = i->Eval(list);
    k = k->Eval(list);
    if (i->isA()==k->isA())
      if (i->compare(k)==0) retv = new pList();
  } else cout << "comparison needs two arguments" << endl;
  if (retv==0) retv = new pInt(1);
  return retv;
}


pElement * _lessthan(pList * list) {
  pElement * retv = 0;
  pElement * i=list->Top()->Next();
  if (i && i->Next()) {
    pElement * k = i->Next();
    i = i->Eval(list);
    k = k->Eval(list);
    if (i->isA()==k->isA())
      if (i->compare(k)<0) retv = new pInt(1);
  } else cout << "comparison needs two arguments" << endl;
  if (retv==0) retv = new pList();
  return retv;
}


pElement * _greaterthan(pList * list) {
  pElement * retv = 0;
  pElement * i=list->Top()->Next();
  if (i && i->Next()) {
    pElement * k = i->Next();
    i = i->Eval(list);
    k = k->Eval(list);
    if (i->isA()==k->isA())
      if (i->compare(k)>0) retv = new pInt(1);
  } else cout << "comparison needs two arguments" << endl;
  if (retv==0) retv = new pList();
  return retv;
}


pElement * _if(pList * list) {
  pElement * retv = 0;
  pElement * el = list->Top()->Next();
  if (el) {
    el = el->Eval(list);
    if (el && ((!el->isList()) || (((pList*)el)->Top()!=0))) {
      if (el->Next() && el->Next()->isList()) {
	pList * prgList = (pList*) el->Next();
	pElement * i = 0;
	for (i=prgList->Top();i!=0;i=i->Next()) {
	  i = i->Eval(prgList);
	}
	if (i) retv = i->copy();
	else retv = new pList();
      } else cout << "*** second parameter has to be a list of commands" << endl;
    } else retv = new pList();
  } else cout << "*** if needs parameters" << endl;
  
  return retv;
}
/*
pElement * _nthval(pList * list) {
  pElement * retv = 0;
  pElement * value = list->Top()->Next();
  if (value) {
    value = value->Eval(list);
    if (value->isInt()) {
      int nth = ((pInt*)value)->getInt();
      pElement * obj = value->Next();
      obj = obj->Eval(list);
      if (obj->isObject()) {
	SyclValence * myVal = ((pObject*) obj)->getValue()->hasValences();
	int i = 0;
	for (i=0; (i<nth) && (myVal!=0); myVal = myVal->next) i++;
	cout << "i: " << i << ", nth: " << nth << ", val: " << myVal << endl;
	if (myVal) retv = new pValence(myVal);
      } else cout << "*** usage: (nthval [0..*] object)" << endl;
    } else cout << "*** usage: (nthval [0..*] object)" << endl;
  }
  if (retv==0) retv = new pList();
  return retv;
}

*/
pElement * _rand(pList * list) {
  pElement * retv = 0;
  pElement * value = list->Top()->Next();
  if (value) {
    value = value->Eval(list);
    if (value->isInt()) {
      int i = ((pInt*) value)->getInt();
      double o = (rand()*1.0/RAND_MAX)*i;
      retv = new pInt(o);
      // cout << "i: " << i << " o: " << o << " max: " << RAND_MAX << endl;
    } else cout << "*** need integer as parameter" << endl;
  } else cout << "*** need integer as parameter" << endl;
  if (retv==0) retv = new pList();
  return retv;
}


/*
#include "enzyme.h"
#include "radical.h"
#include "value.h"
#include "valueMatrix.h"
#include "valueString.h"

extern SyclRadical * renderVirtual(SyclRadical & rad, SyclValence ** v);


pElement * _seto(pList * list) {
  double xx=0; double yy=0; double zz=0;
  pElement * ex = 0; pElement * ey = 0; pElement * ez = 0;
  pElement * retv = 0;
  pElement * var = list->Top()->Next();
  if (var) {
    if (var->isString()) {
      int m = 1; int n = 1;
      ElementNamesIndex type = ERR;
      pElement * opt = var->Next();
      pElement * optmem = 0;
      pString * mystr;
      while (opt && opt->quoted() && opt->isString() && (optmem!=opt)) {
	optmem = opt;
	mystr = (pString*) opt;
	if (strcmp(mystr->getPtr(),"int")==0) { type = INT; opt = opt->Next(); }
	else if (strcmp(mystr->getPtr(),"real")==0) { type = DOUBLE; opt = opt->Next(); }
	else if (strcmp(mystr->getPtr(),"bool")==0) { type = BOOLL; opt = opt->Next(); }
	else if (strcmp(mystr->getPtr(),"enz")==0) { type = ENZYME; opt = opt->Next(); }
	else if (strcmp(mystr->getPtr(),"vector")==0) {
	  opt = opt->Next();
	  opt = opt->Eval(list);
	  if (opt->isInt()) { m = ((pInt*)opt)->getInt(); }
	  opt = opt->Next();
	}
	else if (strcmp(mystr->getPtr(),"covector")==0) {
	  opt = opt->Next();
	  opt = opt->Eval(list);
	  if (opt->isInt()) { n = ((pInt*)opt)->getInt(); }
	  opt = opt->Next();
	}
	else if (strcmp(mystr->getPtr(),"matrix")==0) {
	  opt = opt->Next();
	  opt = opt->Eval(list);
	  if (opt->isInt()) { m = ((pInt*)opt)->getInt(); }
	  opt = opt->Next();
	  opt = opt->Eval(list);
	  if (opt->isInt()) { n = ((pInt*)opt)->getInt(); }
	  opt = opt->Next();
	}
      }
      pElement * value = opt;
      if (value) { // set var to value
	if ((value->isList() && (value->quoted()==0))||(value->isString())) value = value->Eval(list);
	
	if (type==ERR) type = value->isA();
	SyclValue * sval = 0;
	switch (type) {
	case BOOLL: sval = new SyclMatrix<BOOL>(m,n,((pInt*)value)->getInt()); break;
	case INT: sval = new SyclMatrix<int>(m,n,((pInt*)value)->getInt()); break;
	case DOUBLE: sval = new SyclMatrix<double>(m,n,((pDouble*)value)->getDouble()); break;
	case STRING: sval = new SyclStringValue(value->get()); break;
	case ENZYME: sval = 0; break;
	case LIST: sval = new SyclStringValue("not implemented yet"); // DOIT: search for matrix...
	default: sval = new SyclMatrix<double>(m,n,0.0); break;
	}
	if (m*n>1) { // read vector/matrix
	  for (int i=1; i<m*n; i++) {
	    value = value->Next();
	    switch (type) {
	    case BOOLL:  ((SyclMatrix<BOOL>*)sval)->set(((pInt*)value)->getInt(),i); break;
	    case INT:    ((SyclMatrix<int>*)sval)->set(((pInt*)value)->getInt(),i); break;
	    case DOUBLE: ((SyclMatrix<double>*)sval)->set(((pDouble*)value)->getDouble(),i); break;
	      // case STRING: ((SyclStringValue*)sval)->set(((pString*)value)->get(),i); break;
	    default: ((SyclMatrix<double>*)sval)->set(((pDouble*)value)->getDouble(),i); break;
	      
	    }
	  }
	}
	ex = value->Next();
	if (ex) {
	  ex = ex->Eval(list);
	  // cout << ex->elementName() << endl;
	  if (ex->isInt()) xx = ((pInt*)ex)->getInt();
	  if (ex->isDouble()) xx = ((pDouble*)ex)->getDouble();
	  ey = ex->Next();
	  if (ey) {
	    ey = ey->Eval(list);
	    if (ey->isInt()) yy = ((pInt*)ey)->getInt();
	    if (ey->isDouble()) yy = ((pDouble*)ey)->getDouble();
	    ez = ey->Next();
	    if (ez) {
	      ez = ez->Eval(list);
	      if (ez->isInt()) zz = ((pInt*)ez)->getInt();
	      if (ez->isDouble()) zz = ((pDouble*)ez)->getDouble();
	    }
	  }
	}
	SyclObject * o = 0;
	if (type!=ENZYME) {
	  o = new SyclObject(sval);
	} else {
	  o = SyclEnzyme::makeEnzyme(value->get());
	}
	SyclRadical * rad = new SyclRadical(o,xx,yy,zz);
	pObject * obj = new pObject(rad);
	ElPtr * el = new ElPtr(obj,var->get());
	addToElList(el);
	retv = value->copy();
      } else { // evaluate var
	//retv = value->copy();
      }
    } else cout << "*** seto needs string as a variable name" << endl;
  } else cout << "*** seto needs parameters" << endl;
  if (retv==0) retv = new pList();
  return retv;
}

#include "gPres.h"
#include "radList.h"
extern SyclGraphics * gg;

SyclRadical * findRadical(int xx, int yy, int zz) {
  SyclRadical * rad = 0;
  double x0 = 0; double y0 = 0; double z0 = 0;
  for (SyclRadList * optr = gg->nodeList; optr!=0 && rad==0; optr=optr->Next()) {
    SyclRadicalQtPresentation * rpres = (SyclRadicalQtPresentation*) optr->Node();
    if (rpres) {
      rpres->Address()->getPosition()->getSysCoord(x0,y0,z0);
      if ((xx==int(x0))&&(yy==int(y0))&&(zz==int(z0))) {
	rad = rpres->Address();
      }
    }
  }
  if (rad==0) cout << "PANIC: ::findRadical()" << endl;
  return rad;
}

pElement * _connecto(pList * list) {
  pElement * retv = 0;
  pElement * var = list->Top()->Next();
  if (var) {
    if (var->isString()) {
      pElement * ex = var->Next();
      if (ex && ex->isInt()) {
	pElement * ey = ex->Next();
	if (ey && ey->isInt()) {
	  pElement * ez = ey->Next();
	  if (ez && ez->isInt()) {
	    SyclRadical * rad = findRadical(((pInt*)ex)->getInt(),((pInt*)ey)->getInt(),((pInt*)ez)->getInt());
	    if (rad!=0) {
	      pObject * obj = new pObject(rad);
	      ElPtr * el = new ElPtr(obj,var->get());
	      addToElList(el);
	      retv = var->copy();
	    } else retv = Error->copy();
	  }
	}
      }
    }
  }
  if (retv==0) retv = new pList();
  return retv;
}


pElement * _newo(pList * list) {
  pElement * retv = 0;
  pElement * value = list->Top()->Next();
  if (value) { // set var to value
    if ((value->isList() && (value->quoted()==0))||(value->isString())) value = value->Eval(list);
    
    ElementNamesIndex i = value->isA();
    SyclValue * sval = 0;
    int m=1; int n=1; // DOIT!
    switch (i) {
    case INT: sval = new SyclMatrix<int>(m,n,((pInt*)value)->getInt()); break;
    case DOUBLE: sval = new SyclMatrix<double>(m,n,((pDouble*)value)->getDouble()); break;
    case STRING: sval = new SyclStringValue(value->get()); break;
    case LIST: sval = new SyclStringValue("not implemented yet"); // DOIT: search for matrix...
    default: sval = new SyclMatrix<double>(m,n,0.0); break;
    }
    SyclObject * o = new SyclObject(sval);
    SyclRadical * rad = new SyclRadical(o);
    
    retv = new pObject(rad);
    
  } else cout << "*** newo needs parameters" << endl;
  if (retv==0) retv = new pList();
  return retv;
}


SyclAlgebraicValue * createValue(pElement * value) {
  ElementNamesIndex i = value->isA();
  SyclAlgebraicValue * sval = 0;
  int m=1; int n=1; // DOIT!
  switch (i) {
  case INT: sval = new SyclMatrix<int>(m,n,((pInt*)value)->getInt()); break;
  case DOUBLE: sval = new SyclMatrix<double>(m,n,((pDouble*)value)->getDouble()); break;
  case STRING: sval = new SyclStringValue(value->get()); break;
  case LIST: sval = new SyclStringValue("not implemented yet"); // DOIT: search for matrix...
  default: sval = new SyclMatrix<double>(m,n,0.0); break;
  }
}

pElement * _setv(pList * list) {
  pElement * retv = 0;
  pElement * var = list->Top()->Next();
  if (var) {
    if (var->isString()) {
      pElement * value1 = var->Next();
      if (value1) { // set var to value
	pElement * value2 = value1->Next();
	if (value2) {
	  pElement * source = value2->Next();
	  if (source) {
	    pElement * target = source->Next();
	    if (target==0) target = source;
	    if ((source->isList() && (source->quoted()==0))
		|| (source->isString())) source = source->Eval(list);
	    if ((target->isList() && (target->quoted()==0))
		|| (target->isString())) target = target->Eval(list);
	    // check source and target:
	    if (source->isObject() && target->isObject()) {
	      SyclRadical * rad1 = ((pObject*)source)->getValue();
	      SyclRadical * rad2 = ((pObject*)target)->getValue();
	      // check values:
	      if (value1->isList() && (value1->quoted()==0)) value1 = value1->Eval(list);
	      if (value2->isList() && (value2->quoted()==0)) value2 = value2->Eval(list);
	      
	      SyclAlgebraicValue * sval1 = createValue(value1);
	      SyclAlgebraicValue * sval2 = createValue(value2);

	      SyclValence * link = SyclValence::createLink(*rad1,*rad2);
	      link->appendValue(sval1);
	      link->adjointVal->appendValue(sval2);
	      pValence * vvv = new pValence(link);
	      ElPtr * el = new ElPtr(vvv,var->get());
	      addToElList(el);
	      retv = value1->copy();
	    } else cout << "*** source and target have to be objects" << endl;
	  } else cout << "*** to set a valence, 4 arguments are needed" << endl;
	} else cout << "*** to set a valence, 4 parameters are needed" << endl;
      } else { // evaluate var
	//retv = value->copy();
      }
    } else cout << "*** setq needs string as a variable name" << endl;
  } else cout << "*** setq needs parameters" << endl;
  if (retv==0) retv = new pList();
  return retv;
}

pElement * _setl(pList * list) {
  pElement * retv = 0;
  pElement * var = list->Top()->Next();
  if (var) {
    if (var->isString()) {
      pElement * value1 = var->Next();
      if (value1) { // set var to value
	pElement * source = value1->Next();
	if (source) {
	  pElement * target = source->Next();
	  if (target==0) target = source;
	  if ((source->isList() && (source->quoted()==0))
	      || (source->isString())) source = source->Eval(list);
	  if ((target->isList() && (target->quoted()==0))
	      || (target->isString())) target = target->Eval(list);
	  // check source and target:
	  if (source->isObject() && target->isObject()) {
	    SyclRadical * rad1 = ((pObject*)source)->getValue();
	    SyclRadical * rad2 = ((pObject*)target)->getValue();
	    // check values:
	    if (value1->isList() && (value1->quoted()==0)) value1 = value1->Eval(list);
	    	    
	    SyclAlgebraicValue * sval1 = createValue(value1);
	    
	    // SyclValence * link = SyclValence::createLinkSingle(*rad1,*rad2);
	    SyclValence * link = SyclValence::createLink(*rad1,*rad2);
	    renderVirtual(*rad1,&link);
	    link->appendValue(sval1);
	    link->getAdjoint()->appendValue((SyclAlgebraicValue*)sval1->copy());
	    pValence * vvv = new pValence(link);
	    ElPtr * el = new ElPtr(vvv,var->get());
	    addToElList(el);
	    retv = value1->copy();
	  } else cout << "*** source and target have to be objects" << endl;
	} else cout << "*** to set a valence, 4 arguments are needed" << endl;
      } else { // evaluate var
	//retv = value->copy();
      }
    } else cout << "*** setq needs string as a variable name" << endl;
  } else cout << "*** setq needs parameters" << endl;
  if (retv==0) retv = new pList();
  return retv;
}

pElement * _enzymes(pList * list) {
  pList * retVal = new pList();
  BOOL exit=false;
  SyclEnzyme * cur;
  for (int i=0;exit==false;i++) {
    cur = SyclEnzyme::enzymeLib->get(i);
    if (cur==0) { exit=true; }
    else { retVal->appendElement(new pString(cur->codE())); }
  }
  return retVal;
}

#include "enzymeOutput.h"
#include "system.h"

pElement * _run(pList * list) {
  pList * retv = new pList();
  pElement * param = list->Top()->Next();
  SyclRadical * rad = 0;
  SyclRadical * src = 0;
  SyclValence * val = 0;
  SyclValence * vPtr = NULL;
  if (param && param->isList() && ((pList*)param)->length()==2) {
    pList * list2 = (pList*)param;
    pElement * po = list2->Top();
    po = po->Eval(list2);
    pElement * pv = po->Next();
    pv = pv->Eval(list2);
    if (po->isObject() && pv->isValence()) {
      rad = ((pObject*)po)->getValue();
      val = ((pValence*)pv)->getValue();
      src = val->giveFrom();
      if (rad->getObject()->isEnzyme()) {
	// char c;	cin.get(c);
	cout << "attempting to let " << ((SyclEnzyme*)rad->getObject())->codE() << " act on " << ((SyclEnzyme*)src->getObject())->codE() << endl;
	((SyclEnzyme*)rad->getObject())->act(*src,&vPtr);
      }
    }
  }
  return retv;
}

pElement * _applyEnzyme(pList * list) {
  pList * retv = new pList();
  pElement * param = list->Top()->Next();
  // param = param->Eval(list);
  SyclRadical * rad = 0;
  SyclValence * vPtr = NULL;
  // if (param) cout << "! " << ((pString*)param)->quoted() << endl;
 
  if (param && param->isList() && ((pList*)param)->length()==2) {
    pList * list2 = (pList*)param;
    pElement * po = list2->Top();
    po = po->Eval(list2);
    pElement * pv = po->Next();
    pv = pv->Eval(list2);
    // cout << "! " << po->get() << ", " << po->isString() << ", " << po->isObject() << endl;
    // cout << "! " << pv->get() << ", " << pv->isString() << ", " << pv->isValence() << endl;
    if (po->isObject() && pv->isValence()) {
      rad = ((pObject*)po)->getValue();
      vPtr = ((pValence*)pv)->getValue();
    } else cout << "*** parameter list to an enzyme should consist of an object and a valence" << endl;
  } else if (param) {
    param = param->Eval(list);
    if (param->isObject()) {
      pObject * po = (pObject*) param;
      rad = po->getValue();
    } else cout << "*** needs an object" << endl;
  } else cout << "*** need either an object or a list as a parameter for an enzyme" << endl;
  if (rad!=0) {
    pElement * aux = param->Next();
    char * genome = ((pEnzyme*)list->Top())->getValue();
    SyclEnzyme * enz = SyclEnzyme::makeEnzyme(genome);
    if (aux) rad = enz->apply(*rad,vPtr);
    else rad = enz->act(*rad,&vPtr);
    retv->appendElement(new pObject(rad));
    retv->appendElement(new pValence(vPtr));
  }
  
  return retv;
}



pElement * _edit(pList * list) {
  pElement * retv = 0;
  pElement * param = list->Top()->Next();
  param = param->Eval(list);
  if (param->isObject()) {
    pObject * o = (pObject*) param;
    // cout << o->getValue()->getObject()->getValue()->getLine() << endl;
    pElement * pv = param->Next();
    // SyclValue * newVal = __newValue(pv);
    char * line = new char[200];
    char * lptr = line;
    while (pv!=0) {
      sprintf(lptr,"%s ",pv->get());
      lptr += strlen(pv->get());
      lptr++;
      pv = pv->Next();
    }
    // cout << line << endl;
    o->getValue()->getObject()->getValue()->editLine(line);
    delete line;
  } else if (param->isValence()) {
    pValence * v = (pValence*) param;
    pElement * pv = param->Next();
    char * line = new char[200];
    char * lptr = line;
    while (pv!=0) {
      sprintf(lptr,"%s ",pv->get());
      lptr += strlen(pv->get());
      lptr++;
      pv = pv->Next();
    }
    v->getValue()->getValue()->editLine(line);
    delete line;
  } else cout << "*** need an object" << endl;
  retv = new pList();
  return retv;
}


pElement * _appendvalue(pList * list) {
  pElement * retv = 0;
  pElement * param = list->Top()->Next();
  param = param->Eval(list);
  if (param->isObject()) {
    pObject * o = (pObject*) param;
    // cout << o->getValue()->getObject()->getValue()->getLine() << endl;
    pElement * pv = param->Next();
    // SyclValue * newVal = __newValue(pv);
    char * line = new char[200];
    char * lptr = line;
    while (pv!=0) {
      sprintf(lptr,"%s ",pv->get());
      lptr += strlen(pv->get());
      lptr++;
      pv = pv->Next();
    }
    if (o->getValue()->getObject())
      o->getValue()->getObject()->appendValue(new SyclMatrix<int>(1,1,3));
    // o->getValue()->getObject()->getValue()->editLine(line);
    delete line;
  } else if (param->isValence()) {
    pValence * v = (pValence*) param;
    v->getValue()->appendValue(new SyclMatrix<int>(1,1,3));
  } else cout << "*** need an object or valence" << endl;
  retv = new pList();
  return retv;
}


pElement * _addmembrane(pList * list) {
  pElement * retv = 0;
  pElement * param = list->Top()->Next();
  param = param->Eval(list);
  if (param->isValence()) {
    pValence * v = (pValence*) param;
    pElement * pv = param->Next();
    char * line = new char[200];
    char * lptr = line;
    while (pv!=0) {
      sprintf(lptr,"%s ",pv->get());
      lptr += strlen(pv->get());
      lptr++;
      pv = pv->Next();
    }
    v->getValue()->addMembrane(line);
  } else cout << "*** need a valence" << endl;
  retv = new pList();
  return retv;
}


pElement * _makeenz(pList * list) {
  // extern SyclGraphics * gg;
  //obsolete: use (enzyme 'xxxx=yyyyzzzz....)
  pElement * retv = 0;
  if (retv==0) retv = new pList();
  return retv;
}


pElement * _enzyme(pList * list) {
  // extern SyclGraphics * gg;
  pElement * retv = 0;
  pElement * value = list->Top()->Next();
  char * txt = 0;
  if (value) {
    // value = value->Eval(list);
    if (value->isString()) {
      txt = value->get();
      SyclEnzyme * enz = SyclEnzyme::makeEnzyme(txt);
      PRFAC->Environment()->updateEnzymes();
    }
  }
  if (retv==0) retv = new pList();
  return retv;
}

pElement * _adjoint(pList * list) {
  pElement * retv = 0;
  pElement * value = list->Top()->Next();
  if (value) {
    value = value->Eval(list);
    // cout << value->isA() << endl;
    if (value->isValence()) {
      SyclValence * val = ((pValence*) value)->getValue();
      SyclValence * aval = val->getAdjoint();
      retv = new pValence(aval);
    }
  }
  if (retv==0) retv = new pList();
  return retv;
}

pElement * _valences(pList * list) {
  pElement * retv = 0;
  pElement * value = list->Top()->Next();
  if (value) {
    value = value->Eval(list);
    if (value->isObject()) {
      int i = 0;
      for (SyclValence * val = ((pObject*) value)->getValue()->hasValences(); val!=0; val = val->next) i++;
      retv = new pInt(i);
    } else cout << "*** needs and object" << endl;
  }
  if (retv==0) retv = new pList();
  return retv;
}

*/

/*
pElement * _transform(pList * list) {
  pElement * retv = 0;
  pElement * value = list->Top()->Next();
  pElement * value1 = 0;
  int type = -1;
  double tr = 0;
  if (value) {
    value = value->Eval(list);
    value1 = value->Next();
    if (value1) {
      value1 = value1->Eval(list);
      if (value->isInt()) type = ((pInt*)value)->getInt();
      if (value->isDouble()) type = (int) ((pDouble*)value)->getDouble();
      if (value1->isDouble()) tr = ((pDouble*)value1)->getDouble();
      if ((type != -1)&&(tr!=0)) {
	// PRFAC->Environment()
      }
    }
  }
  
  if (retv==0) retv = new pList();
  return retv;
}
*/

/** dummy function template to copy:

pElement * _fun(pList * list) {
  pElement * retv = 0;
  for (pElement * i=list->Top()->Next();i!=0;i=i->Next()) {
    i = i->Eval(list);
  }
  return retv;
}

*/


#endif
