#ifndef _COPYEVENT_H_
#define _COPYEVENT_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Event;
class Part;
class Table;

/** This operation copies one or more events to the position p
 */
class CopyEvent : public Operation
{
 private:
  Event * _event;
  Event * _delete;
  Part  * _part;
  Table * _selection;
  Table * _delete_sel;


 public:
  CopyEvent(Position p, Event * ev, Part * pt, int pitch = 0);
  CopyEvent(const CopyEvent&);
  ~CopyEvent();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
