#include "includes.h"

int verifiedatoi(char * string)
{
    char *atoi_test;
    int atoiret;
    
    atoiret=atoi(string);
    asprintf(&atoi_test,"%d",atoiret);
    if (strcmp(atoi_test, string)==0)
    {
	return atoiret;
    }
    else
    {
	return -1;
    }
}

byte calc_checksum (byte * knl, int size)
{
  char checksum;
  int i;
  for (i = 0, checksum = 0; i < size; i++)
    checksum += (*knl++);
  checksum = -(checksum);
  return checksum;
}

void usage()
{
    fprintf(stderr,"Smart Boot Manager UNIX Configurator\n");
    fprintf(stderr,"(C)opyright Risko Gergely, 2000.\n");
    fprintf(stderr,"Can be licensed under the terms of GPL v2 or above\n");
    fprintf(stderr,"Usage 1.: bmconf [[--themesdir <dir>] --install theme] --device <device> options\n");
    fprintf(stderr,"With this form you can specify the things by hand\n");
    fprintf(stderr,"Usage 2.: bmconf [--configfile <filename>]\n");
    fprintf(stderr,"With this a config file will be used, default is /etc/bmconf.conf\n");
    fprintf(stderr,"For more please view the bmconf.8 man page.\n");
    exit(-1);
}

char * drvidtostring(unsigned char id)
{
    static char retval[4];
    retval[3]=0;
    
    if (id<128)
    {
	sprintf(retval,"FD%1d",id);
    }
    else if (id<MIN_CDROM_ID)
    {
	sprintf(retval,"HD%1d",id-128);
    }
    else
    {
	sprintf(retval,"CD%1d",id-MIN_CDROM_ID);
    }
    
    return retval;
}

char * partidtostring(unsigned char partid)
{
    static char retval[7];
    retval[6]=0;

    if (partid<5)
    {
	if (partid)
	    sprintf(retval,"Pri %2d", partid);
	else
	    sprintf(retval,"BR");
    }
    else
    {
	sprintf(retval,"Log %2d", partid);
    }
    return retval;
}

void parsefdhdxadd(char *optarg, int *removefloppy, unsigned char *removehard, unsigned char *removepartid, char **removedrive)
{
    *removefloppy=0;
    *removehard=0;
    *removepartid=0;
    *removedrive=NULL;
    
    if (strncmp(optarg,"/dev/",5)!=0)
    {
        usage();
    }
    if ((optarg[5]=='f') && (optarg[6]=='d'))
    {
        *removefloppy=0;
	if (isdigit(optarg[7]) && (optarg[8]==0))
	{
	    if (sscanf(optarg,"/dev/fd%1d", removefloppy)!=1) 
	    {
	        usage();
	    }
	    asprintf(removedrive, "/dev/fd%1d", *removefloppy);
	    *removefloppy+=1;
	}
	else
	{
	    usage();
	}
    }
    else
    {
	char *tmpdrive;
	
	driveparse(optarg, &tmpdrive, removehard);
	partparse(tmpdrive, removedrive, removepartid);
	*removehard-=127;
	free(tmpdrive);
    }
}

int drivecheck(char *drive)
{
    int retval=1;
    int fd;
    struct struc_bootmanager btmgr;
    
    fd=open(drive,O_RDWR);
    if (fd==-1) retval=0;
    else
    {
	struct struc_sbml_header head;
	
	if (sizeof(head)!=read(fd, &head, sizeof(head))) 
	{
	    perror("read");
	    retval=0;
	}
	if (SBML_MAGIC!=head.magic) 
	{
	    fprintf(stderr,"Wrong magic in sbml_header\n");
	    retval=0;
	}
	if (SBML_VERSION!=head.version)
	{
	    fprintf(stderr,"Wrong version in sbml_header\n");
	    retval=0;
	}
    }

    bmread(drive, &btmgr);
    if (fd==-1) retval=0;
    else
    {
	if (SBMK_VERSION!=btmgr.sbmkheader.version)
	{
	    fprintf(stderr,"Wrong version in sbmk_header\n");
	    retval=0;
	}
	if (SBMK_MAGIC!=btmgr.sbmkheader.magic)
	{
	    fprintf(stderr,"Wrong magic in sbmk_magic\n");
	    retval=0;
	}
    	close(fd);
    }

    free(btmgr.data);
    return retval;
}

int reccheck(struct struc_bootrecord record)
{
        if ((record.flags & DRVFLAG_DRIVEOK) &&
	    (((record.flags & INFOFLAG_ISDRIVER) && (record.part_id==0)) 
	    || (record.type!=0)))
	{
	    return 1;
	}
	else
	{
	    return 0;
	}
}

void driveparse(char *string, char **drive, unsigned char *drivenum)
{
    char *running;
    char *str2;
    char *token;
    
    str2=malloc(strlen(string)+1);
    strcpy(str2, string);
    str2[strlen(string)]=0;
    running=str2;
    asprintf(drive, "%s", strsep(&running, ":"));
    token=running;
    if (token)
    {
	if (sscanf(token, "%x", (unsigned int *) drivenum)!=1)
	{
	    usage();
	}
    }
    else
    {
	if (strstr(string,"/fd"))
	    *drivenum=0;
	else
	    *drivenum=128;
    }
    free(str2);
}

void partparse(char *drive, char **device, unsigned char *partnum)
{
    int i;
    char *numstr;
        
    *device=NULL;
    *partnum=0;
    for (i=0;i<strlen(drive);i++)
    {
	if (isdigit(drive[i]))
	{
	    *partnum*=10;
	    *partnum+=drive[i]-48;
	}
	else
	{
	    *partnum=0;
	}
    }
    asprintf(&numstr, "%d", *partnum);
    *device=malloc(strlen(drive)-strlen(numstr)+1);
    (*device)[strlen(drive)-strlen(numstr)]=0;
    strncpy(*device, drive, strlen(drive)-strlen(numstr));    
    free(numstr);
}

