/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

// Taken from Effective Java
// Ordinal-based typesafe enum - Page 106, serializable as per Page 107

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Enumeration for all Transmission commands
 * 
 *  Taken   from Effective Java
 *  Ordinal-  based typesafe enum - Page 106, serializable as per Page 107
 * 
 *  Added a couple more types by Hamish for unindex requests. 
 *
 * @author Adrian Pronk
 * @version 1
 */

public class ECommand implements Comparable, Serializable
{
  // Unique SerialVersionUID (should NEVER change)
  static final long serialVersionUID = 0L;

  private final transient String name;

  // Ordinal of next type to be created
  private static int nextOrdinal = 0;

  // Assign an ordinal to this type
  private final int ordinal = nextOrdinal++;

  public static final ECommand INDEX            = new ECommand("INDEX");
  public static final ECommand QUERY            = new ECommand("QUERY");
  public static final ECommand CONTROL          = new ECommand("CONTROL");
  public static final ECommand UNINDEX          = new ECommand("UNINDEX");              //added by hmc
  public static final ECommand INDEX_RESPONSE   = new ECommand("INDEX-RESPONSE");
  public static final ECommand UNINDEX_RESPONSE = new ECommand("UNINDEX-RESPONSE");     //added by hmc
  public static final ECommand QUERY_RESPONSE   = new ECommand("QUERY-RESPONSE");
  public static final ECommand CONTROL_RESPONSE = new ECommand("CONTROL-RESPONSE");
  public static final ECommand ERROR            = new ECommand("ERROR");

  // Exporting constants - Page 106
  
  //hmc - added unindex to array below.
  private static final ECommand[] PRIVATE_VALUES =
      { INDEX, QUERY, CONTROL, UNINDEX, UNINDEX_RESPONSE, INDEX_RESPONSE,
        QUERY_RESPONSE, CONTROL_RESPONSE, ERROR };

  public static final List VALUES =
      Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));

  public static final Map BY_NAME = new HashMap();
  static
  {
    for (int i = 0; i < PRIVATE_VALUES.length; ++i)
      BY_NAME.put(PRIVATE_VALUES[i].getName().toUpperCase(), PRIVATE_VALUES[i]);
  }

  private ECommand(String name)
  {
    this.name = name;
  }

  public String toString()
  {
    return "ECommand[" + name + "]" ;
  }

  public int compareTo(Object o)
  {
      return ordinal - ((ECommand)o).ordinal;
  }

  private Object readResolve() throws ObjectStreamException {
      return PRIVATE_VALUES[ordinal]; // Canonicalize
  }

  public String getName()
  {
    return name;
  }

  public static ECommand getByName(String name)
  {
    return (ECommand) BY_NAME.get(name.toUpperCase());
  }
}