/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.IOException;
import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Backup
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    Backup(Transmission transmission) {
        this.input = transmission;
    }

    Transmission execute() {
        long afterBackup;
        long afterWriterOpen;
        long beforeOpen;
        Transmission response;
        block35: {
            IndexWriter newIndex;
            FSDirectory luceneDir;
            long queryStart = System.currentTimeMillis();
            response = new Transmission(ECommand.CONTROL_RESPONSE);
            response.setSerial(this.input.getSerial());
            String appName = this.input.get("Application", Constants.NO_APP);
            Log.info("About to Backup Index");
            try {
                this.application = Application.getAppOrDefault(appName);
            }
            catch (ApplicationMissingException e) {
                return this.error(e.getMessage());
            }
            this.input.setApplication(this.application);
            Analyzer analyzer = Application.getAnalyzer(this.input);
            File luceneStoreDir = Application.getIndexDirectory(this.application);
            if (luceneStoreDir == null) {
                return this.error("Application's Index Directory could not be retreived.");
            }
            Log.info(" Source Directory: " + luceneStoreDir);
            try {
                luceneDir = FSDirectory.getDirectory((File)luceneStoreDir, (boolean)false);
            }
            catch (IOException e) {
                return this.error(e.getMessage());
            }
            String newDir = this.input.get("BackUpTarget", Constants.USE_APP);
            if (newDir != null) {
                Log.debug(" using target from request");
            } else {
                newDir = this.input.get("Lucene-Backup-Directory", Constants.USE_APP);
                if (newDir != null) {
                    Log.debug(" using target from application properties");
                } else {
                    newDir = System.getProperty(String.valueOf(IPackage.PACKAGE) + "Lucene-Backup-Directory");
                    if (newDir != null) {
                        Log.debug(" using target from System.config");
                    } else {
                        Log.debug(" No target Directory supplied. Using default");
                        newDir = luceneStoreDir + "_backup";
                    }
                }
            }
            Log.info(" Target Directory:" + newDir);
            File newFile = new File(newDir);
            Log.info(" Target directory exists:      " + newFile.exists());
            Log.info(" Target directory writable:    " + newFile.canWrite());
            Log.info(" Target directory isDirectory: " + newFile.isDirectory());
            if (!newFile.exists()) {
                Log.info(" Attempting to create target directory.");
                boolean success = newFile.mkdirs();
                Log.info(" Successfull creation of directory: " + success);
            } else {
                Log.warn("Index Backup (for application: " + appName + ") will overwrite target directory: " + newDir);
            }
            if (!newFile.isDirectory()) {
                return this.error("Backup target is NOT a directory: " + newDir);
            }
            if (!newFile.canWrite()) {
                return this.error("Application cannot write to target directory: " + newDir);
            }
            beforeOpen = System.currentTimeMillis();
            boolean succeed = false;
            try {
                newIndex = new IndexWriter(newDir, analyzer, true);
                Log.debug(" Created new index in target directory");
            }
            catch (IOException e) {
                return this.error(e.getMessage());
            }
            Log.debug("About to backup index in: " + luceneStoreDir);
            afterWriterOpen = System.currentTimeMillis();
            Directory[] dirs = new Directory[]{luceneDir};
            try {
                try {
                    Log.debug("about to addIndexes");
                    newIndex.addIndexes(dirs);
                    Log.info("Successfully Backed Up Index");
                    afterBackup = System.currentTimeMillis();
                    succeed = true;
                }
                catch (IOException e) {
                    Transmission transmission;
                    block32: {
                        String message = "Error while backing up " + luceneStoreDir + ": " + e.toString();
                        Log.log(ELog.ERROR, message);
                        transmission = this.error(message);
                        Object var21_26 = null;
                        if (newIndex != null) {
                            try {
                                newIndex.close();
                            }
                            catch (Throwable e2) {
                                String message2 = "Error while closing IndexWriter: " + e2.toString();
                                Log.log(ELog.ERROR, message2);
                                if (!succeed) break block32;
                                return this.error(message2);
                            }
                        }
                    }
                    return transmission;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Transmission transmission;
                    block33: {
                        String message = "Error while backing up (probable index corruption) " + luceneStoreDir + ": " + e.toString();
                        Log.log(ELog.ERROR, message);
                        transmission = this.error(message);
                        Object var21_27 = null;
                        if (newIndex != null) {
                            try {
                                newIndex.close();
                            }
                            catch (Throwable e2) {
                                String message2 = "Error while closing IndexWriter: " + e2.toString();
                                Log.log(ELog.ERROR, message2);
                                if (!succeed) break block33;
                                return this.error(message2);
                            }
                        }
                    }
                    return transmission;
                }
            }
            catch (Throwable throwable) {
                block34: {
                    Object var21_28 = null;
                    if (newIndex != null) {
                        try {
                            newIndex.close();
                        }
                        catch (Throwable e2) {
                            String message2 = "Error while closing IndexWriter: " + e2.toString();
                            Log.log(ELog.ERROR, message2);
                            if (!succeed) break block34;
                            return this.error(message2);
                        }
                    }
                }
                throw throwable;
            }
            Object var21_29 = null;
            if (newIndex != null) {
                try {
                    newIndex.close();
                }
                catch (Throwable e2) {
                    String message2 = "Error while closing IndexWriter: " + e2.toString();
                    Log.log(ELog.ERROR, message2);
                    if (!succeed) break block35;
                    return this.error(message2);
                }
            }
        }
        long afterWriterClose = System.currentTimeMillis();
        response.add("Open", String.valueOf(afterWriterOpen - beforeOpen));
        response.add("Backup", String.valueOf(afterBackup - afterWriterOpen));
        response.add("Close", String.valueOf(afterWriterClose - afterBackup));
        return response;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        Log.error("ERROR during BACKUP: " + message);
        return response;
    }
}

