/****************************************************************
**
** Attal : Lords of Doom
**
** displayArtefacts.cpp
** Displays the artefacts of a lord
**
** Version : $Id: displayArtefacts.cpp,v 1.3 2004/12/13 15:14:59 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 06/12/2003
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "displayArtefacts.h"

// generic include files
// include files for QT
#include <qlayout.h>
#include <qpushbutton.h>
// application specific include files
#include "libCommon/artefactManager.h"
#include "libCommon/dataTheme.h"

#include "libClient/graphicalArtefact.h"
#include "libClient/gui.h"
#include "libClient/imageTheme.h"
#include "libClient/player.h"

extern QString IMAGE_PATH;
extern DataTheme DataTheme;
extern ImageTheme ImageTheme;



//
// ----- DisplayArtefacts -----
//

DisplayArtefacts::DisplayArtefacts( Player * player, QWidget * parent, const char * name )
	: QFrame( parent, name )
{
	_player = player;
	_index = 0;
	_used = 0;
	uint i;

	setBackgroundPixmap( IMAGE_PATH + "misc/artefactLord.png" );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->addStretch( 1 );

	QHBoxLayout * layH1 = new QHBoxLayout();

	QPushButton * pb1 = new QPushButton( this );
	pb1->setText( "<" );
	FIXEDSIZE( pb1 );
	layH1->addWidget( pb1 );

	/// WIN: was "_used = new (IconArtefact *) [DataTheme.specifications.getArtefactNumber()];"
	_used = new IconArtefact * [DataTheme.specifications.getArtefactNumber()];
	SpecificationArtefact * temp;

	for( i = 0; i < DataTheme.specifications.getArtefactNumber(); i++ ) {
		temp = DataTheme.specifications.getArtefact( i );
		_used[i] = new IconArtefact( this );
		_used[i]->move( temp->getX(), temp->getY() );
	}

	layH1->addStretch( 1 );

	for( i = 0; i < 3; i++ ) {
		_ico[i] = new IconArtefact( this );
		_ico[i]->clear();
		layH1->addWidget( _ico[i] );
	}

	layH1->addStretch( 1 );
	QPushButton * pb2 = new QPushButton( this );
	pb2->setText( ">" );
	FIXEDSIZE( pb2 );
	layH1->addWidget( pb2 );

	layout->addLayout( layH1 );

	layout->activate();

	connect( pb1, SIGNAL( clicked() ), SLOT( slot_prevArtefact() ) );
	connect( pb2, SIGNAL( clicked() ), SLOT( slot_nextArtefact() ) );
}

DisplayArtefacts::~DisplayArtefacts()
{
	if( _used ) {
		delete [] _used;
	}
}

void DisplayArtefacts::reinit()
{
	GenericLord * lord = _player->getSelectedLord();

	if(lord){
		for( int i = 0; i < 3; i++ ) {
			if( ( _index + i ) < lord->getArtefactManager()->getArtefactNumber() ) {
				_ico[i]->setType( lord->getArtefactManager()->getArtefact( _index + i )->getType() );
			} else {
				_ico[i]->clear();
			}
		}
	}
}

void DisplayArtefacts::slot_nextArtefact()
{
	GenericLord * lord = _player->getSelectedLord();

	if(lord){
		if( _index + 3 < lord->getArtefactManager()->getArtefactNumber() ) {
			_index++;
			reinit();
		}
	}
}

void DisplayArtefacts::slot_prevArtefact()
{
	if( _index > 0 ) {
		_index--;
		reinit();
	}
}


