/* util.h: misc utility functions for Atari fdisk
 *
 * Copyright (C) 1995-97 Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *               1996-97 Michael Schlueter <schlue00@marvin.informatik.uni-dortmund.de>
 *
 * This program is free software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation: either version 2 or
 * (at your option) any later version.
 *
 */

#ifndef _util_h
#define _util_h

/* $Id: util.h,v 1.3 1997/07/08 18:59:06 rnhodek Exp $
 *
 * $Log: util.h,v $
 * Revision 1.3  1997/07/08 18:59:06  rnhodek
 * Ouch, too many changes without commits in between...
 * Implemented moving of partitions
 * Implemented checking of "extended start condition" (great changes in
 *   new_partition())
 * Some more tests in verify()
 *
 * Revision 1.2  1997/06/21 20:47:52  rnhodek
 * Added RCS keywords
 *
 * Revision 1.1  1997/06/11 14:36:36  rnhodek
 * Initial revision
 * 
 * Revision 1.1.1.1  1997/06/11 14:36:36  rnhodek
 * Started using CVS for atafdisk
 *
 */

#include "fdisk.h"

/***************************** Prototypes *****************************/

void fatal( enum failure why ) __attribute((noreturn));
char *round_mb( unsigned long secs );
char *atari_partition_type( char *type);
int is_valid_PID( const char *id );
int is_reasonable_PID( const char *id );
int is_valid_part_entry( struct apartition *pi );
void list_atari_types( void );
char *atari_boot_type( unsigned char flag);
char *atari_boot_type_short( unsigned char flag);
int check_rootsec_checksum( char *buf );
void recalc_rootsec_checksum( char *buf );

/************************* End of Prototypes **************************/


#define	min(a,b)				\
({						\
    typeof(a) _a = (a);				\
    typeof(b) _b = (b);				\
    ( _a < _b ? _a : _b );			\
})

#define	max(a,b)				\
({						\
    typeof(a) _a = (a);				\
    typeof(b) _b = (b);				\
    ( _a < _b ? _b : _a );			\
})

#endif  /* _util_h */

/* Local Variables: */
/* tab-width: 8     */
/* End:             */
