/* :: ascii-jump project
   :: $Id: hill.c,v 1.2 2003/03/02 20:38:01 loth Exp $
  
   :: copyright (c) 2000, 2003  
   :: grzegorz moskal, g.moskal@opengruop.org
   :: michal moskal, malekith@pld-linux.org
   :: przemyslaw niezborala, finburson@o2.pl
   
   :: license gnu gpl v 2						*/

#define HILL_C
#include "hill.h"

char fill[10][10] = {
".%#<==-,-.",
",*#===-(-.",
",#=#==---.",
".8#===-.-.",
".&#=:=---.",
",#=:==:_-.",
",@#==`-~-.",
".H#===`--.",
".#====-^`.",
",*=/==--'."
};
#define TEST2
void hill_intro(struct hill *h)
{
#ifndef TEST2
	char *txt = xmalloc(sizeof(char) * (strlen(h->name)+10));
	char *t2;
	sprintf(txt, "%s  k%d", h->name, h->k/2);
	t2 = strwide(txt);
	typewriter(t2, -1, -1);
	xfree(t2);
	xfree(txt);
#else
	(void)h;
#endif
}

struct hill* hill_find(struct hill *hills, char *pattern)
{
	struct hill *jmp = hills;
	for (; jmp; SWITCH(jmp))
		if (strcmp(jmp->name, pattern) == 0)
			break;
	return jmp;
}

static int ix2(int x, double p)
{
	return (int)(p * x * x);
}

static void hill_fill(struct hill *m)
{
	int *place = m->caption;
	int len = m->len;

	int l1, l2, l3;
	int p, k, i;
	double w1 = 0.0033, w2 = 0.0034, w3 = 0.0025;

	for (i = 0; i < 60; i++)
		*place++ = 0;
	len -= 180;
	
	l1 = len * 12 / 33;
	l2 = len * (12 + 9) / 33;
	l3 = len;
	p = len / 33;

	i = 0;

	for (; i < l1; i++)
		place[i] = ix2(-l1 + i, w1);
	m->leapsill = i + 60;		

	for (; i < l2; i++)
		place[i] = -ix2(i - l1, w2) - p;

	k = -place[i - 1] + ix2(-l3 + i - 1, w3);
	
	for (; i < l3; i++)
		place[i] = ix2(-l3 + i, w3) - k;

	p = place[0] - place[i - 1];
	k = -place[i - 1];

	for (i = 0; i < len; i++)
		place[i] = p - (place[i] + k);
		
	for (i = l1; i > l1 -l1/3; i--)
		if (place[i] == place[i-6])
			m->pns = (i-9) + 60;
			
	for (i = l3; i > l3 - l3/3; i--)
		if (place[i] == place[i-6])
			m->pnz = (i-6) +60;
			
	for (p = place [l3-1], i = l3; i < l3+120; place[i++] = p);
}

static struct hill* hill_init(int len, char *name)
{
	struct hill *m = xmalloc(sizeof(struct hill));
	int i;
	m->name = strdup(name);
	m->k = len*2;
	m->record = 0;
	m->next = NULL;
	
	len += 10;
	len = len*4 + 180;

	m->len = len;

	m->caption = xmalloc(sizeof(int)*(len+1));
	hill_fill(m);
	
	m->fill_no = xmalloc(sizeof(int)*(len+1));
	for (i = 0; i < len; i++)
		m->fill_no[i] = d(10) - 1;

	return m;
}

void hill_draw(struct object *jumper)
{
	struct hill *m= jumper->current_hill;
	int scr_x, scr_y, dd, px;
	int offset_x = jumper->x - sl_screen_width/2;
	int offset_y = jumper->y - sl_screen_height/2;
	
	sl_color(Lwhite);	
	
	if (offset_x < 0) 
		offset_x = 0; 
		
	for (scr_y = 0; scr_y < HEIGHT-1; scr_y++) {
		for (scr_x = 0; scr_x < WIDTH; scr_x++) {
			px = offset_x + scr_x;
			if (((dd = m->caption[px] - (scr_y + offset_y))) >= 0)
				continue;

			sl_goto(scr_x, scr_y);
			
			if (dd > -10) { 
				if (px == m->k + m->leapsill && dd != -1) {
					sl_color(Red + d(2)-1);
					sl_putch('|');
				} else if (px == (int)(2*m->record + m->leapsill) && dd != -1) {
					sl_color(Green + d(2)-1);
					sl_putch('|');
				} else {
				 	sl_color(Lwhite);
					sl_putch(fill[m->fill_no[px]][-dd - 1]);
				}
			} else if (dd == -10 && px > m->leapsill + m->k/2 
				&& px < m->pnz) {
				if (px % 10 == 7) {
					char tab[4]; 
					sprintf(tab, "%d", (px - m->leapsill)/2);
					sl_color(Red);
					sl_addstrxy(tab, scr_x-2, scr_y);
					sl_color(Lwhite);
				} else
					sl_putch('-');
			} else {
				sl_color(White);
				sl_putch('\"');
			}
		}
	}
		
	sl_color(Cyan);
	sl_addstrxy(m->name, WIDTH/2-strlen(m->name)/2, HEIGHT-1);
	

	if (jumper->new_owner) {
		sl_color(Brown);
		sl_addstrxy("n e w   h i l l   r e c o r d .", WIDTH/2-10, HEIGHT/2-6);
	}
}

static char *hillname;
static short hilllength;

int hills_readconf(char *filename)
{
	FILE *fd = xfopen(filename, "r");
	char *line = NULL;
	
	
	while ((line = read_line(fd))) {
		if (strstr (line, "name=")) {
			if (hillname)
				xfree(hillname);

			hillname = strdup(&line[5]);
		}
			
		if (strstr (line, "length=")) 
			hilllength = atoi(&line[7]);

		xfree(line);
	}

	if (hilllength == 0 && hillname == NULL)	
		return 0;
		
	return 1;
}

struct hill *hills_init(char *dirname, int *nh)
{
	struct hill *tmp, *first = NULL, *last = NULL;
	struct dirent *j;
	char *currentdir = xgetcwd();
	DIR *where = xopendir(dirname);
	int i = 0;

	if (where == NULL)
		return NULL;
		
	xchdir(dirname);
	
	while ((j = readdir(where))) {
		if (*j->d_name == '.' || strcmp("core", j->d_name) == 0)
			continue;
		
		hilllength = 0;

		if (hillname)
			hillname = xfree(hillname);

		if (hills_readconf(j->d_name) == 0)
			continue;
		

		tmp = hill_init(hilllength, hillname);
		record_read(hillname, &tmp->record, &tmp->owner);

		if (first) {
			last->next = tmp;
			last = tmp;
		} else
			first = last = tmp;
			
		i++;
	}
	
	xchdir(currentdir);
	xfree(currentdir);
	*nh = i;

	return first;
}
