# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::MainWindow::Revisions;

use Glib qw(TRUE FALSE);
use Gtk2;

use base qw(ArchWay::MainWindow::Base ArchWay::MainWindow::RevisionBase);

sub init ($) {
	my $self = shift;

	$self->SUPER::init;
	$self->add_revision_actions;

	my @items = (
		[ "RevisionMenu", undef, "_Revision" ],
	);

	# menu/toolbar layout
	my $layout = <<_EOF_;
<ui>
	<menubar name="MenuBar">
		<placeholder name="ApplicationMenus">
			<menu action="RevisionMenu">
				<menuitem action="GetTree" />
				<menuitem action="GetCSet" />
				<menuitem action="ViewCSet" />
				<menuitem action="ViewLog" />
			</menu>
		</placeholder>
	</menubar>

	<toolbar name="ToolBar">
		<toolitem action="GetTree" />
		<toolitem action="GetCSet" />
		<toolitem action="ViewCSet" />
		<toolitem action="ViewLog" />
	</toolbar>
</ui>
_EOF_

	# add menu/toolbar to ui
	my $actions = Gtk2::ActionGroup->new('RevisionListActions');
	$actions->add_actions(\@items, undef);

	$self->ui->insert_action_group($actions, 0);
	$self->ui->add_ui_from_string($layout);

	#init ui
	$self->set_default_size(700, 500);
}

sub main_widget ($) {
	my $self = shift;

	if (! exists $self->{main_widget}) {
		my $scwin_fv = Gtk2::ScrolledWindow->new();
		$scwin_fv->set_policy('automatic', 'automatic');
		$scwin_fv->add($self->revisions_view());

		$self->{main_widget} = $scwin_fv;
	}

	return $self->{main_widget};
}

sub add_revision_descs ($$;%) {
	my $self = shift;

	$self->revisions_view->add_revision_descs(@_);
}

sub clear ($) {
	my $self = shift;

	$self->revisions_view->clear;
}

1;

__END__
