// testvscreen.cc
//
//  I really need a test for the vscreen libraries that's separate from the
// main Aptitude program.  This is it.

#include "fragment.h"
#include "vscreen.h"
#include "vscreen_widget.h"
#include "vs_button.h"
#include "vs_center.h"
#include "vs_editline.h"
#include "vs_frame.h"
#include "vs_label.h"
#include "vs_layout_item.h"
#include "vs_multiplex.h"
#include "vs_minibuf_win.h"
#include "vs_menu.h"
#include "vs_menubar.h"
#include "vs_pager.h"
#include "vs_radiogroup.h"
#include "vs_scrollbar.h"
#include "vs_size_box.h"
#include "vs_stacked.h"
#include "vs_subtree.h"
#include "vs_table.h"
#include "vs_text_layout.h"
#include "vs_togglebutton.h"
#include "vs_tree.h"
#include "vs_util.h"

#include <config/colors.h>

#include <string>

#include <sigc++/bind.h>
#include <sigc++/object_slot.h>

using namespace std;

// Er..having this be global is not so great?
vs_stacked *stacker=new vs_stacked(0,0);

class test_keyname:public vs_label
{
public:
  test_keyname():vs_label("")
  {
    set_bg(get_color("EditLine"));
  }

  size size_request()
  {
    return size(10, 0);
  }

  bool focus_me() {return true;}

  bool handle_char(chtype ch) {set_text(keyname(ch)); return true;}
};

class silly_block:public vscreen_widget
{
public:
  silly_block(int mybkgd)
  {
    set_bg(mybkgd);
  }

  size size_request()
  {
    return size(0,0);
  }

  void paint()
  {
  }
};

class silly_treeitem:public vs_treeitem
{
  string txt;
public:
  silly_treeitem(string _txt):txt(_txt) {}

  void paint(vs_tree *win, int y, bool hierarchical)
  {
    vs_treeitem::paint(win, y, hierarchical, txt);
  }

  const char *tag() const {return txt.c_str();}
  const char *label() const {return txt.c_str();}
};

class silly_subtree:public vs_subtree_generic
{
  string txt;
public:
  silly_subtree(bool expanded, string _txt)
    :vs_subtree_generic(expanded), txt(_txt) {}

  void paint(vs_tree *win, int y, bool hierarchical)
  {
    vs_subtree_generic::paint(win, y, hierarchical, txt);
  }

  const char *tag() const {return txt.c_str();}
  const char *label() const {return txt.c_str();}
};

void do_toggle_hierarchical(vs_tree *tree)
{
  tree->set_hierarchical(!tree->get_hierarchical());
}

vscreen_widget *make_test_treewidget()
{
  vs_tree *tree=new vs_tree();

  silly_subtree *root=new silly_subtree(true, "The Root Of It All");
  silly_subtree *tree1=new silly_subtree(false, "Money");
  tree1->add_child(new silly_treeitem("Gold"));
  tree1->add_child(new silly_treeitem("Copper"));
  tree1->add_child(new silly_treeitem("Silver"));
  tree1->add_child(new silly_treeitem("Paper"));
  root->add_child(tree1);

  silly_subtree *tree2=new silly_subtree(false, "Entropy");
  silly_subtree *tree3=new silly_subtree(true, "Mortality");
  tree3->add_child(new silly_treeitem("Death"));
  tree3->add_child(new silly_treeitem("Famine"));
  tree3->add_child(new silly_treeitem("Pestilence"));
  tree3->add_child(new silly_treeitem("War"));
  tree2->add_child(tree3);
  tree2->add_child(new silly_treeitem("Rot"));
  tree2->add_child(new silly_treeitem("Decay"));
  tree2->add_child(new silly_treeitem("Bad Things"));
  root->add_child(tree2);

  // A commentary on the analytical machine, translated by Lady Ada.
  silly_subtree *anaengine=new silly_subtree(false, "Charles B.");
  anaengine->add_child(new vs_layout_item(sequence_fragment(flowbox(text_fragment("Those labours which belong to the various branches of the mathematical sciences, although on first consideration they seem to be the exclusive province of intellect, may, nevertheless, be divided into two distinct sections; one of which may be called the mechanical, because it is subjected to precise and invariable laws, that are capable of being expressed by means of the operations of matter; while the other, demanding the intervention of reasoning, belongs more specially to the domain of the understanding. This admitted, we may propose to execute, by means of machinery, the mechanical branch of these labours, reserving for pure intellect that which depends on the reasoning faculties. Thus the rigid exactness of those laws which regulate numerical calculations must frequently have suggested the employment of material instruments, either for executing the whole of such calculations or for abridging them; and thence have arisen several inventions having this object in view, but which have in general but partially attained it. For instance, the much-admired machine of Pascal is now simply an object of curiosity, which, whilst it displays the powerful intellect of its inventor, is yet of little utility in itself. Its powers extended no further than the execution of the first four operations of arithmetic, and indeed were in reality confined to that of the first two, since multiplication and division were the result of a series of additions and subtractions. The chief drawback hitherto on most of such machines is, that they require the continual intervention of a human agent to regulate their movements, and thence arises a source of errors; so that, if their use has not become general for large numerical calculations, it is because they have not in fact resolved the double problem which the question presents, that of correctness in the results, united with economy of time.")),
							    newline_fragment(),
							    flowbox(text_fragment("Struck with similar reflections, Mr. Babbage has devoted some years to the realization of a gigantic idea. He proposed to himself nothing less than the construction of a machine capable of executing not merely arithmetical calculations, but even all those of analysis, if their laws are known. The imagination is at first astounded at the idea of such an undertaking; but the more calm reflection we bestow on it, the less impossible does success appear, and it is felt that it may depend on the discovery of some principle so general, that, if applied to machinery, the latter may be capable of mechanically translating the operations which may be indicated to it by algebraical notation. The illustrious inventor having been kind enough to communicate to me some of his views on this subject during a visit he made at Turin, I have, with his approbation, thrown together the impressions they have left on my mind. But the reader must not expect to find a description of Mr. Babbage's engine; the comprehension of this would entail studies of much length; and I shall endeavour merely to give an insight into the end proposed, and to develop the principles on which its attainment depends.")),
							    NULL)));
  root->add_child(anaengine);

  silly_subtree *tree4=new silly_subtree(false, "More stuff");
  for(int i=0; i<10; i++)
    {
      char buf[32];

      snprintf(buf, sizeof(buf), "Category %d", i);

      silly_subtree *sub=new silly_subtree(false, buf);
      for(int j=0; j<10; j++)
	{
	  snprintf(buf, sizeof(buf), "Item %d", j);
	  sub->add_child(new silly_treeitem(buf));
	}

      tree4->add_child(sub);
    }
  root->add_child(tree4);
  root->sort();

  tree->set_root(root, true);

  tree->connect_key("ToggleHier", &global_bindings,
		    bind(slot(do_toggle_hierarchical), tree));

  return tree;
}

void show_nasty_message()
{
  stacker->add_visible_widget(vs_dialog_ok("Your mother was a hamster, and your father smelt of elderberry!\n\n\tNow go away, or I shall taunt you a second time!", NULL), true);
}

void interrogate()
{
  stacker->add_visible_widget(vs_dialog_yesno("Do you like Debian?", NULL, SigC::slot(show_nasty_message)), true);
}

void dobeep()
{
  beep();
}

vs_menu_info test_file_menu[]=
{
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Interrogate", NULL,
   "NO-ONE EXPECTS THE SPANISH INQUISITION!", SigC::slot(&interrogate)),
  VS_MENU_SEPARATOR,
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Quit", "Quit",
   "Leave this wonderful program", SigC::slot(&vscreen_exitmain)),
  VS_MENU_END,
};

vs_menu_info test_test_menu[]=
{
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "Test ^Item 1", NULL, "Foo", SigC::slot(&dobeep)),
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "Test Item ^2", NULL, "Bar", SigC::slot(&dobeep)),
  VS_MENU_SEPARATOR,
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "Test Item ^3", NULL, "Baz", SigC::slot(&dobeep)),
  VS_MENU_END
};

vs_menu_info test_help_menu[]=
{
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^About", NULL, "Useless dialog box",
	       VS_MENU_NOP),
  VS_MENU_SEPARATOR,
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Help...", "Help", "unimplemented",
	       VS_MENU_NOP),
  vs_menu_info(vs_menu_info::VS_MENU_ITEM, "^Don't help...", NULL, "unimplemented",
	       VS_MENU_NOP),
  VS_MENU_END
};

void radio_button_selected(int id, vs_label *l)
{
  char buf[128];

  snprintf(buf, 128, "You have selected button %i", id);
  l->set_text(buf);
}

vscreen_widget *button_mania()
{
  vs_table *rval=new vs_table;
  vs_label *label=new vs_label("ERROR");

  rval->add_widget(label, 5, 0, 1, 4, false);

  for(int i=0; i<4; i++)
    {
      vs_radiogroup *g=NULL;

      if(i==3)
	{
	  g=new vs_radiogroup;
	  g->item_selected.connect(bind(slot(&radio_button_selected), label));
	}
      for(int j=0; j<4; j++)
	{
	  char buf[256];
	  snprintf(buf, 256, "Button %i", i*4+j);

	  if(i!=3)
	    rval->add_widget(new vs_button(buf), i, j, 1, 1);
	  else
	    {
	      vs_togglebutton *b=new vs_radiobutton(buf);
	      rval->add_widget(b, i, j, 1, 1, true);
	      g->add_button(b, i*4+j);
	    }
	}
    }

  rval->add_widget_opts(new vs_checkbutton("Button 16"), 4, 0, 1, 2,
			vs_table::ALIGN_CENTER,
			vs_table::ALIGN_CENTER | vs_table::EXPAND);
  rval->add_widget_opts(new vs_button("Button 17"), 4, 2, 1, 2,
			vs_table::ALIGN_CENTER,
			vs_table::ALIGN_CENTER | vs_table::EXPAND);

  return rval;
}

static void do_load_file(string s, vs_editline *p)
{
  p->set_text("");
}

vscreen_widget *pager_test()
{
  vs_table *tbl=new vs_table;
  vs_editline *ln=new vs_editline("Enter a filename to load: ");
  const char *s="This space for rent.\n\nApply above.";
  vs_file_pager *pager=new vs_file_pager(s, strlen(s));
  vs_scrollbar *scrl=new vs_scrollbar(vs_scrollbar::VERTICAL, 0, 0);

  tbl->add_widget_opts(ln, 0, 0, 1, 2, vs_table::EXPAND | vs_table::SHRINK, vs_table::SHRINK);
  tbl->add_widget_opts(pager, 1, 0, 1, 1, vs_table::SHRINK, vs_table::EXPAND);
  tbl->add_widget_opts(scrl, 1, 1, 1, 1, vs_table::ALIGN_LEFT, vs_table::EXPAND);

  ln->entered.connect(bind(SigC::slot(&do_load_file), ln));
  ln->entered.connect(slot(*pager, &vs_file_pager::load_file));
  pager->line_changed.connect(slot(*scrl, &vs_scrollbar::set_slider));
  pager->do_line_signal();
  scrl->scrollbar_interaction.connect(slot(*pager, &vs_pager::scroll_page));

  return tbl;
}

void update_menu_status(vs_menu_item *item, vs_label *label)
{
  if(item)
    {
      label->show();
      label->set_text(item->get_description());
    }
  else
    label->hide();
}

void do_editline_history(std::string s, vs_editline *l)
{
  l->add_to_history(s);
  l->reset_history();
  l->set_text("");
}

// This isn't a very comprehensive test yet.
vscreen_widget *make_layout_test()
{
  vs_table *t=new vs_table;

  vector<fragment*> v;

  v.push_back(indentbox(2, 2, flowbox(fragf("%s %s %s", "A", "Christmas", "Carol"))));

  v.push_back(newline_fragment());

  v.push_back(flowbox(fragf("%BMarley was %s%b: to begin with.  There is %F whatever about that. The register of his burial was signed by the clergyman, the clerk, the undertaker, and the chief mourner. Scrooge signed it. And Scrooge's name was good upon 'Change, for anything he chose to put his hand to. Old Marley was as dead as a door-nail.",
			    "dead",
			    text_fragment("no doubt", A_BOLD))));

  v.push_back(newline_fragment());

  // Test positional arguments.
  v.push_back(fillbox(fragf("%2$F! I don't mean to say that I know, of my own knowledge, what there is particularly dead about a door-nail. I might have been inclined, myself, to regard a coffin-nail as the deadest piece of ironmongery in the trade. But the wisdom of our ancestors is in the simile; and my unhallowed hands shall not disturb it, or the Country's done for. You will therefore permit me to repeat, emphatically, that Marley was as %3$F as a %1$F.%n%n%n%nScrooge knew he was dead? Of course he did. How could it be otherwise? Scrooge and he were partners for I don't know how many years. Scrooge was his sole executor, his sole administrator, his sole assign, his sole residuary legatee, his sole friend, and sole mourner. And even Scrooge was not so dreadfully cut up by the sad event, but that he was an excellent man of business on the very day of the funeral, and solemnised it with an undoubted bargain.",
			    text_fragment("door-nail", A_BOLD),
			    text_fragment("Mind", A_BOLD),
			    text_fragment("dead", A_BOLD))));

  vs_text_layout *l=new vs_text_layout(sequence_fragment(v));
  vs_scrollbar *s=new vs_scrollbar(vs_scrollbar::VERTICAL);
  l->location_changed.connect(slot(*s, &vs_scrollbar::set_slider));
  s->scrollbar_interaction.connect(slot(*l, &vs_text_layout::scroll));

  t->add_widget_opts(l, 0, 0, 1, 1, vs_table::EXPAND, vs_table::EXPAND);
  t->add_widget_opts(s, 0, 1, 1, 1, 0, vs_table::EXPAND);

  return t;
}

int main(int argc, char *argv[])
{
  vscreen_init();

  global_bindings.set("CycleScreen", KEY_F(6));
  global_bindings.set("CycleScreenBack", KEY_F(7));
  global_bindings.set("ToggleCellVisible", KEY_F(5));
  global_bindings.set("ToggleHier", 'h');

  vs_menubar *menubar=new vs_menubar();

  menubar->connect_key_post("Quit", &global_bindings, SigC::slot(&vscreen_exitmain));

  vs_label *menu_display=new vs_label("", get_color("ScreenStatusColor"));

  vs_menu *menu=new vs_menu(0, 0, 0, test_file_menu);
  menubar->append_item("File", menu);
  menu->item_highlighted.connect(bind(slot(&update_menu_status),
				      menu_display));

  menu=new vs_menu(0, 0, 0, test_test_menu);
  menubar->append_item("Test", menu);
  menu->item_highlighted.connect(bind(slot(&update_menu_status),
				      menu_display));

  menu=new vs_menu(0, 0, 0, test_help_menu);
  menubar->append_item("Help", menu);
  menu->item_highlighted.connect(bind(slot(&update_menu_status),
				      menu_display));

  vs_minibuf_win *toplevel=new vs_minibuf_win();

  toplevel->add_widget(menu_display);

  menubar->set_subwidget(toplevel);

  vs_multiplex *switcher=new vs_multiplex();
  switcher->connect_key("CycleScreen",
			&global_bindings,
			slot(*switcher, &vs_multiplex::cycle_forward));
  switcher->connect_key("CycleScreenBack",
			&global_bindings,
			slot(*switcher, &vs_multiplex::cycle_backward));

  switcher->add_visible_widget(pager_test(), true);
  switcher->add_visible_widget(button_mania(), true);

  switcher->add_visible_widget(new vs_center(new vs_size_box(size(20, 8), new vs_frame(new vs_center(new vs_label("\tThis is another screen.\nNotice that both tabs and newlines work properly."))))), true);
  switcher->add_visible_widget(new vs_label("This is one screen."), true);
  switcher->add_visible_widget(vs_dialog_ok("Press any key to hide this widget"), true);
  switcher->add_visible_widget(make_test_treewidget(), true);

  vs_table *ttable=new vs_table;
  ttable->add_widget(new vs_frame(new vs_label("Press a key:")));
  ttable->add_widget(new vs_frame(new test_keyname));
  ttable->show_all();
  switcher->add_widget(ttable);

  vs_table *table=new vs_table;
  table->set_colsep(3);
  vscreen_widget *w=new vs_frame(new vs_center(new vs_label("Pane 1")));
  table->add_widget(w, 0, 0, 2, 1, false);
  w=new vs_frame(new vs_center(new vs_label("Pane 2")));
  table->add_widget_opts(w, 0, 1, 1, 1, vs_table::EXPAND, 0);

  vs_editline::history_list h;
  vs_editline *l=new vs_editline(20, "Input: ", "Pane 3", &h);
  l->entered.connect(bind(SigC::slot(&do_editline_history),
			  l));

  w=new vs_frame(new vs_center(l));
  table->add_widget(w, 1, 1);
  w=new vs_frame(new vs_center(new vs_label("Pane 4 - a pane with a very long label in it\nwhich should crowd out the other table cells")));
  table->connect_key("ToggleCellVisible",
		     &global_bindings,
		     slot(*w, &vscreen_widget::toggle_visible));
  table->add_widget(w, 0, 2, 2);
  table->show_all();
  switcher->add_widget(table);

  switcher->add_visible_widget(make_layout_test(), true);

  stacker->add_visible_widget(switcher, true);

  stacker->add_visible_widget(vs_dialog_ok("Vscreen test program - press any key to begin"), true);

  toplevel->set_main_widget(stacker);
  stacker->show();
  toplevel->set_header("testvscreen");
  toplevel->set_header("This program tests the vscreen text UI library");

  vscreen_settoplevel(menubar);

  vscreen_mainloop();

  rootwin.bkgdset(' ');
  rootwin.clear();
  rootwin.refresh();
  endwin();

  return 0;
}
