// pkg_node.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Implementations of stuff in pkg_node.h

#include "vscreen/config/keybindings.h"

#include "pkg_node.h"

#include "ui.h"

#include <generic/apt.h>
#include <generic/apt_undo_group.h>
#include <generic/config_signal.h>
#include <generic/undo.h>

#include <vscreen/vs_tree.h>

keybindings *pkg_tree_node::bindings=NULL;

void pkg_tree_node::init_bindings()
{
  bindings=new keybindings(&global_bindings);
}

// FIXME: add a do_action() command that takes a function pointer and does all
// the extra junk below.
bool pkg_tree_node::dispatch_char(chtype ch, vs_tree *owner)
{
  undo_group *grp=new apt_undo_group;

  if(bindings->key_matches(ch, "Install"))
    select(grp);
  else if(bindings->key_matches(ch, "Remove"))
    remove(grp);
  else if(bindings->key_matches(ch, "Hold"))
    hold(grp);
  else if(bindings->key_matches(ch, "Keep"))
    keep(grp);
  else if(bindings->key_matches(ch, "Purge"))
    purge(grp);
  else if(bindings->key_matches(ch, "Reinstall"))
    reinstall(grp);
  else if(bindings->key_matches(ch, "SetAuto"))
    set_auto(true, grp);
  else if(bindings->key_matches(ch, "ClearAuto"))
    set_auto(false, grp);
  else
    {
      delete grp;

      return false;
    }

  if(!grp->empty())
    apt_undos->add_item(grp);
  else
    delete grp;

  if(aptcfg->FindB(PACKAGE "::UI::Advance-On-Action", false))
    owner->level_line_down();

  package_states_changed();

  return true;
}
