#! /usr/bin/perl

# this are hooks the overload the methods in apt-cacher-lib.pl and implement
# data checksumming methods

use DBI;
use Fcntl ':flock';
use IO::Handle;
use POSIX;
use Digest::MD5 qw(md5_hex);


my $ctx;
my $dbfile;
my $dbh;
my $dblck;

sub dbauf {
   open($dblck, $dbfile);
   flock($dblck, LOCK_EX);
   $dbh = DBI->connect("dbi:SQLite:dbname=$dbfile","", "",
   { RaiseError => 1, AutoCommit => 0 } );
}

sub dbzu {
   $dbh->disconnect;
   flock($dblck, LOCK_UN);
   close($dblck);
}

# arg: file to be scanned and added to DB
sub import_sums {
   my %sumhash;
   extract_sums(shift, \%sumhash);
   dbauf();
   for(keys %sumhash) {
      #$dbh->do("insert or ignore into sums values(\"$_\", \"$sumhash{sum}\");");
      $dbh->do("replace into sums values(\"$_\", \"".$sumhash{$_}."\");");
   }
   $dbh->commit;
   dbzu();
}

sub db_init {
   $dbfile=shift;
   if(!-s $dbfile) { 
      open $db, ">$dbfile"; close $db; # touch it
      dbauf();
      $dbh->do("CREATE TABLE sums (file varchar PRIMARY KEY, sum varchar(32) NOT NULL);");
      $dbh->commit;
      dbzu();
   }
}

# purpose: create hasher object
sub data_init {
   $ctx = Digest::MD5->new;
   return 1;
}

# purpose: append data to be scanned
sub data_feed {
   $ref=shift;
   $ctx->add($$ref);
}

# arg: filename
sub check_sum {
   my $file=shift;
   my $digest = $ctx->hexdigest;
   dbauf();
   my @sqlar = $dbh->selectrow_array("select sum from sums where file='$file'");
   dbzu();
   if(defined($sqlar[0]) && $sqlar[0] ne '') {
      # now find the faulty deb
      return ($sqlar[0] eq $digest);
   }
   return 1;
}


1;
