% ----------------------------------------------------------------------------
% - manual.cls                                                               -
% - a manual class for latex                                                 -
% ----------------------------------------------------------------------------
% - copyright (c) 2003 amaury darsch                                         -
% ----------------------------------------------------------------------------

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{manual}
              [2003/04/01 1.0 manual latex class]

% So far, only A4 and letter paper is supported since we have strict rules
% with text width and height
\newcommand\@pgfmt{}
\DeclareOption{A4}
   {\renewcommand\@pgfmt{a4}%
    \setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{letter}
   {\renewcommand\@pgfmt{lt}%
    \setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}

% quality of page, can be either standard or luxury. Standard is more
% appropriate for manual, while lux is for book.
\newif\if@stdpage
\newif\if@luxpage
\@stdpagetrue
\@luxpagefalse
\DeclareOption{stdpage}{\@stdpagetrue  \@luxpagefalse}
\DeclareOption{luxpage}{\@stdpagefalse \@luxpagetrue}

% Point size is defined as 0,1,2 and get translated as 1{0}, 1{1} or 1{2}
\newcommand\@ptsize{}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}

% Declare either one side or two side option
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}

% Execute options
\ExecuteOptions{A4,10pt,twoside,stdpage}
\ProcessOptions

% Load point size related definition
\input{man1\@ptsize.clo}

% Load page format related definition
\input{man\@pgfmt.clo}

% Set default page numbering to arabic - this initialize \thepage as well
\pagenumbering{arabic}

% Front matter, main matter and back matter
\newif\if@mainmatter 
\@mainmattertrue

\newcommand\frontmatter{%
  \cleardoublepage
  \@mainmatterfalse
  \pagenumbering{roman}}

\newcommand\mainmatter{%
  \cleardoublepage
  \@mainmattertrue
  \pagenumbering{arabic}}

\newcommand\backmatter{%
  \cleardoublepage
  \@mainmatterfalse
}

% plain headings is empty
\if@twoside
  \def\ps@plain{%
    \let\@oddhead\@empty
    \let\@oddfoot\empty
    \let\@evenhead\@empty
    \let\@evenfoot\@empty
  }
  \else
\def\ps@plain{%
    \let\@oddhead\@empty
    \let\@oddfoot\empty
  }
\fi

% define standard headings with page number
\if@twoside
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \let\@evenfoot\@empty
    \def\@evenhead{\textbf{\thepage\hfil\leftmark}}%
    \def\@oddhead{\textbf{\rightmark\hfil\thepage}}%
    \let\@mkboth\markboth
    \def\chaptermark##1{\markboth{##1}{}}%
    \def\sectionmark##1{\markright{##1}}%
  }
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{\rightmark\hfil\thepage}%
    \let\@mkboth\markboth
    \def\chaptermark##1{\markright{##1}{}}%
  }
\fi

% part definition
\newcounter{part}
\renewcommand\thepart{\@Roman\c@part}

% chapter definition
\newcounter{chapter}
\newcommand*\chaptermark[1]{}
\renewcommand\thechapter{\@arabic\c@chapter}

% chapter command
\newcommand\chapter{%
  \cleardoublepage%
  \thispagestyle{plain}%
  \@chapter
}

% chapter issue definition
\def\@chapter#1{%
  \if@mainmatter
    \refstepcounter{chapter}%
  \fi
  \if@mainmatter
    \chaptermark{#1}%
    \addcontentsline{toc}{chapter}{%
      \protect\parbox[t]{2em}{\thechapter}#1}%
  \else
    \@mkboth{\MakeUppercase{#1}}{\MakeUppercase{#1}}
    \addcontentsline{toc}{chapter}{#1}%
  \fi
  \@makechapterhead{#1}%
}

% chapter formating command
\newcommand\@chapapp{\chaptername}
\def\@makechapterhead#1{%
  \noindent\rule{\linewidth}{1pt}%
  \vskip\chapterskip
  \if@luxpage
    \begin{center}%
      \if@mainmatter
        {\Large\MakeUppercase{\@chapapp\space\thechapter}}%
        \linebreak\linebreak
      \fi
      {\huge\bfseries #1}%
    \end{center}%  
  \else
    \begin{flushright}%
      \if@mainmatter
        {\Huge\sffamily\bfseries\MakeUppercase{\@chapapp\space\thechapter}}%
        \linebreak\linebreak
      \fi
      {\Huge\sffamily\bfseries #1}%
    \end{flushright}%  
  \fi
  \vskip\sectionskip
  \noindent\rule{\linewidth}{1pt}%
  \vskip\sectionskip%
}

% section definition
\newcounter{section}[chapter]
\renewcommand\thesection{\thechapter.\@arabic\c@section}

% section command
\newcommand\section{%
  \@section
}

% section issue definition
\def\@section#1{%
  \refstepcounter{section}%
  \if@mainmatter
    \sectionmark{#1}%
    \addcontentsline{toc}{section}{%
      \protect\parbox[t]{3em}{\thesection}#1}%
  \else
    \addcontentsline{toc}{section}{#1}%
  \fi
  \@makesectionhead{#1}%
}

% section formating command
\def\@makesectionhead#1{%
  \vskip\sectionskip%
  \if@luxpage
    \if@mainmatter
      {\noindent\large\bfseries\thesection\quad #1}
    \else
      {\noindent\large\bfseries #1}
    \fi
  \else
    \if@mainmatter
      {\noindent\large\sffamily\bfseries\thesection\quad #1}
    \else
      {\noindent\large\sffamily\bfseries #1}
    \fi
  \fi
  \vskip\lineskip%
}

% subsection definition
\newcounter{subsection}[section]
\renewcommand\thesubsection{\thesection.\@arabic\c@subsection}

% subsection command
\newcommand\subsection{%
  \@subsection
}

% subsection issue definition
\def\@subsection#1{%
  \refstepcounter{subsection}%
  \if@mainmatter
    \addcontentsline{toc}{subsection}{%
       \protect\parbox[t]{4em}{\thesubsection}#1}%
  \else
    \addcontentsline{toc}{subsection}{#1}%
  \fi
  \vskip\subsectionskip%
  \@makesubsectionhead{#1}%
}

% subsection formating
\def\@makesubsectionhead#1{%
  \if@luxpage
    \if@mainmatter
      {\noindent\bfseries\thesubsection\quad #1}
    \else
      {\noindent\bfseries #1}
    \fi
  \else
    \if@mainmatter
      {\noindent\sffamily\bfseries\thesubsection\quad #1}
    \else
      {\noindent\sffamily\bfseries #1}
    \fi
  \fi
  \vskip\lineskip%
}

% Table of contents
\newcommand\tableofcontents{%
  \@mkboth{\MakeUppercase\contentsname}{\MakeUppercase\contentsname}
  \@maketochead
  \@starttoc{toc}%
}

% Table of contents formating
\def\@maketochead{%
  \thispagestyle{plain}
  \noindent\rule{\linewidth}{1pt}%
  \vskip\chapterskip%
  \if@luxpage
    \begin{center}%
      \Large\MakeUppercase\contentsname
    \end{center}%  
  \else
    \begin{flushright}%
      \huge\sffamily\bfseries\MakeUppercase\contentsname
    \end{flushright}%  
  \fi
  \vskip\chapterskip
  \noindent\rule{\linewidth}{1pt}%
  \vskip\sectionskip
}

% chapter formating in toc
\def\l@chapter#1#2{%
  \vskip\sectionskip
  {\noindent\normalfont\normalsize\bfseries #1\hfill #2}%
}

% section formating in toc
\def\l@section#1#2{%
  \vskip\z@
  {\noindent\normalfont\normalsize\hskip 2em #1\hfill #2}%
}

% subsection formating in toc
\def\l@subsection#1#2{%
  \vskip\z@
  {\noindent\normalfont\normalsize\hskip 5em #1\hfill #2}%
}

% appendix setting
\newcommand\appendix{%
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \gdef\@chapapp{\appendixname}%
  \gdef\thechapter{\@Alph\c@chapter}%
}

% list margin metric
\setlength\leftmargini   {3em}
\setlength\leftmarginii  {2em}
\setlength\leftmarginiii {1.5em}
\setlength\leftmarginiv  {1.5em}  
\setlength\leftmarginv   {1em}
\setlength\leftmarginvi  {1em}
\leftmargin\leftmargini

% list label metric
\setlength\labelsep{.5em}
\setlength\labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}

% enumerated list formating
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}

%itemize list
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\textbullet}
\newcommand\labelitemiii{\textbullet}
\newcommand\labelitemiv{\textbullet}

% description list
\newenvironment{description}{%
  \list{}{\labelwidth\z@ \itemindent-\leftmargin
             \let\makelabel\descriptionlabel}}%
  {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

% float metrics and formating
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}

% table ruling
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}

% bibliography environment
\newdimen\bibindent
\setlength\bibindent{1.5em}
\let\@openbib@code\@empty

\newenvironment{thebibliography}[1]%
  {\@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}
   \@makebibhead
   \list{\@biblabel{\@arabic\c@enumiv}}
        {\settowidth\labelwidth{\@biblabel{#1}}
         \leftmargin\labelwidth
         \advance\leftmargin\labelsep
	 \@openbib@code
         \usecounter{enumiv}
         \let\p@enumiv\@empty
         \renewcommand\theenumiv{\@arabic\c@enumiv}}
  }
  {\endlist\cleardoublepage}

\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}

% bibliography formating
\def\@makebibhead{%
  \thispagestyle{plain}
  \cleardoublepage
  \noindent\rule{\linewidth}{1pt}%
  \vskip\chapterskip%
  \if@luxpage
    \begin{center}%
      \Large\MakeUppercase\bibname
    \end{center}%  
  \else
    \begin{flushright}%
      \huge\sffamily\bfseries\MakeUppercase\bibname
    \end{flushright}%  
  \fi
  \vskip\chapterskip
  \noindent\rule{\linewidth}{1pt}%
  \vskip\sectionskip
}

% index environment
\newenvironment{theindex}
  {\@mkboth{\MakeUppercase\indexname}{\MakeUppercase\indexname}
   \@makeidxhead
   \thispagestyle{plain}
   \columnseprule \z@
   \columnsep 35\p@
   \twocolumn
   \parindent\z@
   \parskip\z@ \@plus .3\p@\relax
   \let\item\@idxitem}
  {\onecolumn\cleardoublepage}

\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{20\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}

% index formating
\def\@makeidxhead{%
  \thispagestyle{plain}
  \cleardoublepage
  \noindent\rule{\linewidth}{1pt}%
  \vskip\chapterskip%
  \if@luxpage
    \begin{center}%
      \Large\MakeUppercase\indexname
    \end{center}%  
  \else
    \begin{flushright}%
      \huge\sffamily\bfseries\MakeUppercase\indexname
    \end{flushright}%  
  \fi
  \vskip\chapterskip
  \noindent\rule{\linewidth}{1pt}%
  \vskip\sectionskip
}

% default page style
\pagestyle{headings}

\endinput
