// ---------------------------------------------------------------------------
// - cerr.hxx                                                                -
// - standard system library - c system error platform function definition   -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (ALEPH_PLATFORM_PROCID == ALEPH_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif


// linux
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_LINUX)
#define  ALEPH_HAVE_ERRNO
#include <errno.h>
#include <exception>
#endif

// solaris
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_SOLARIS)
#define  ALEPH_HAVE_ERRNO
#include <errno.h>
#include <exception>
#endif

// freebsd
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_FREEBSD)
#define  ALEPH_HAVE_ERRNO
#include <errno.h>
#include <exception>
#endif
