// ---------------------------------------------------------------------------
// - Libawww.cpp                                                             -
// - aleph:www library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Url.hpp"
#include "Meta.hpp"
#include "Libawww.hpp"
#include "CgiQuery.hpp"
#include "HtmlPage.hpp"
#include "Predawww.hpp"
#include "Function.hpp"
#include "XHtmlPage.hpp"

namespace aleph {
  Object* init_aleph_www (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;
    
    // create the aleph:sys nameset
    Nameset* aset = interp->mknset ("aleph", interp->getgset ());
    Nameset* awww = interp->mknset ("www",   aset);
    
    // bind all classes in the aleph:net nameset
    awww->symcst ("Url",             new Meta (Url::mknew));
    awww->symcst ("Cookie",          new Meta (Cookie::mknew));
    awww->symcst ("CgiQuery",        new Meta (CgiQuery::mknew));
    awww->symcst ("HtmlPage",        new Meta (HtmlPage::mknew));
    awww->symcst ("XHtmlPage",       new Meta (XHtmlPage::mknew));
    
    // bind all predicates in the aleph:www nameset
    awww->symcst ("url-p",          new Function (www_urlp));
    awww->symcst ("cookie-p",       new Function (www_cokp));
    awww->symcst ("html-page-p",    new Function (www_htmp));
    awww->symcst ("cgi-query-p",    new Function (www_cgip));

    // not used but needed
    return nilp;
  }
}

extern "C" {
  aleph::Object* dli_aleph_www (aleph::Interp* interp, aleph::Vector* argv) {
    return init_aleph_www (interp, argv);
  }
}
