// ---------------------------------------------------------------------------
// - CgiQuery.hpp                                                            -
// - aleph:www library - cgi query class definition                          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_CGIQUERY_HPP
#define  ALEPH_CGIQUERY_HPP

#ifndef  ALEPH_STRVEC_HPP
#include "Strvec.hpp"
#endif

namespace aleph {

  /// The CgiQuery class is a simple class that parses a cgi query string
  /// and extract the name value pairs. When the string is parsed, the
  /// standard character transliteration is performed.
  /// @author amaury darsch

  class CgiQuery : public Object {
  private:
    /// the query string
    String d_query;
    /// the name vector
    Strvec d_names;
    /// the value vector
    Strvec d_value;

  public:
    /// create an empty cgi query
    CgiQuery (void);

    /// create a cgi query by string
    /// @param queury the string to parse
    CgiQuery (const String& query);

    /// @return the class name
    String repr (void) const;

    /// reset the query
    void reset (void);

    /// parse a cgi query by name
    /// @param query the query to parse
    void parse (const String& query);

    /// @return the number of name-pair values
    long length (void) const;

    /// @return true if a name exists
    bool exists (const String& name) const;

    /// @return the name index by name
    long lookup (const String& name) const;

    /// @return a value by name
    String get (const String& name) const;

    /// @return a name by index
    String getname (const long index) const;

    /// @return a value by index
    String getvalue (const long index) const;

    /// generate a new cgi query object
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// apply this cgi query with a set of arguments and a quark
    /// @param robj  robj the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);

  private:
    // make the copy constructor private
    CgiQuery (const CgiQuery&);
    // make the assignment operator private
    CgiQuery& operator = (const CgiQuery&);
  };
}

#endif
